/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageFormatException;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageTypeException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.MapCursor;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueRef;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.holder.ValueHolder;
import org.msgpack.value.impl.AbstractValueRef;

public class MapCursorImpl
extends AbstractValueRef
implements MapCursor {
    private final ValueHolder valueHolder;
    private MessageUnpacker unpacker;
    private int cursor = 0;
    private int mapSize;

    public MapCursorImpl(ValueHolder valueHolder) {
        this.valueHolder = valueHolder;
    }

    public void reset(MessageUnpacker messageUnpacker) throws IOException {
        this.unpacker = messageUnpacker;
        this.cursor = 0;
        this.mapSize = messageUnpacker.unpackMapHeader();
    }

    @Override
    public int size() {
        return this.mapSize;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.cursor < this.mapSize * 2 && this.unpacker.hasNext();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public ValueRef nextKeyOrValue() {
        try {
            MessageFormat messageFormat = this.unpacker.unpackValue(this.valueHolder);
            ++this.cursor;
            return this.valueHolder.getRef();
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public void skipKeyOrValue() {
        try {
            this.unpacker.skipValue();
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public void skipAll() {
        while (this.hasNext()) {
            this.skipKeyOrValue();
        }
    }

    private void ensureNotTraversed() {
        if (this.cursor != 0) {
            throw MessagePackException.UNSUPPORTED("MapCursor is already traversed");
        }
    }

    @Override
    public MapCursor getMapCursor() throws MessageTypeException {
        return this;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.MAP;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        this.ensureNotTraversed();
        messagePacker.packMapHeader(this.mapSize);
        while (this.hasNext()) {
            messagePacker.packValue(this.nextKeyOrValue().toValue());
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitMap(this.toValue());
    }

    @Override
    public MapValue toValue() {
        this.ensureNotTraversed();
        Value[] valueArray = new Value[this.mapSize * 2];
        int n = 0;
        while (this.hasNext()) {
            valueArray[n++] = this.nextKeyOrValue().toValue();
        }
        return ValueFactory.newMap(valueArray);
    }
}

