/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.msgpack.value.Value;

class ValueUnion {
    private Type type;
    private long longValue;
    private double doubleValue;
    private Object objectValue;

    ValueUnion() {
    }

    public void reset() {
        this.type = null;
    }

    public boolean isSet() {
        return this.type != null;
    }

    public Type getType() {
        return this.type;
    }

    public void setBoolean(boolean bl) {
        this.type = Type.BOOLEAN;
        this.longValue = bl ? 1L : 0L;
    }

    public boolean getBoolean() {
        return this.longValue != 0L;
    }

    public void setLong(long l) {
        this.type = Type.LONG;
        this.longValue = l;
    }

    public long getLong() {
        return this.longValue;
    }

    public void setBigInteger(BigInteger bigInteger) {
        this.type = Type.BIG_INTEGER;
        this.objectValue = bigInteger;
    }

    public BigInteger getBigInteger() {
        return (BigInteger)this.objectValue;
    }

    public void setDouble(double d) {
        this.type = Type.DOUBLE;
        this.doubleValue = d;
    }

    public double getDouble() {
        return this.doubleValue;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.type = Type.BYTE_BUFFER;
        this.objectValue = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return (ByteBuffer)this.objectValue;
    }

    public void setString(String string) {
        this.type = Type.STRING;
        this.objectValue = string;
    }

    public String getString() {
        return (String)this.objectValue;
    }

    public void setList(List<Value> list) {
        this.type = Type.LIST;
        this.objectValue = list;
    }

    public List<Value> getList() {
        return (List)this.objectValue;
    }

    public void setMap(Map<Value, Value> map) {
        this.type = Type.MAP;
        this.objectValue = map;
    }

    public Map<Value, Value> getMap() {
        return (Map)this.objectValue;
    }

    public static enum Type {
        BOOLEAN,
        LONG,
        BIG_INTEGER,
        DOUBLE,
        BYTE_BUFFER,
        STRING,
        LIST,
        MAP;

    }
}

