/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class OutputStreamBufferOutput
implements MessageBufferOutput {
    private OutputStream out;
    private MessageBuffer buffer;
    private byte[] tmpBuf;

    public OutputStreamBufferOutput(OutputStream outputStream) {
        this.out = Preconditions.checkNotNull(outputStream, "output is null");
    }

    public void reset(OutputStream outputStream) throws IOException {
        outputStream.close();
        this.out = outputStream;
    }

    @Override
    public MessageBuffer next(int n) throws IOException {
        if (this.buffer == null || this.buffer.size != n) {
            this.buffer = MessageBuffer.newBuffer(n);
            return this.buffer;
        }
        return this.buffer;
    }

    @Override
    public void flush(MessageBuffer messageBuffer) throws IOException {
        int n = messageBuffer.size();
        if (messageBuffer.hasArray()) {
            this.out.write(messageBuffer.getArray(), messageBuffer.offset(), n);
        } else {
            if (this.tmpBuf == null || this.tmpBuf.length < n) {
                this.tmpBuf = new byte[n];
            }
            messageBuffer.getBytes(0, this.tmpBuf, 0, n);
            this.out.write(this.tmpBuf, 0, n);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.flush();
        }
        finally {
            this.out.close();
        }
    }
}

