/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.value.impl;

import java.io.IOException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.value.BooleanValue;
import org.msgpack.core.value.ValueType;
import org.msgpack.core.value.ValueVisitor;
import org.msgpack.core.value.impl.AbstractValue;

public class BooleanValueImpl
extends AbstractValue
implements BooleanValue {
    public static BooleanValue TRUE = new BooleanValueImpl(true);
    public static BooleanValue FALSE = new BooleanValueImpl(false);
    private final boolean value;

    public BooleanValueImpl(boolean bl) {
        this.value = bl;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanValue)) {
            return false;
        }
        return this.value == ((BooleanValue)object).toBoolean();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean toBoolean() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBoolean(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitBoolean(this.value);
    }

    @Override
    public BooleanValue toValue() {
        return this;
    }
}

