/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.msgpack.core.ExtendedTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageFormatException;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageSizeException;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.core.MessageTypeException;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.value.Cursor;
import org.msgpack.value.ValueType;
import org.msgpack.value.holder.FloatHolder;
import org.msgpack.value.holder.IntegerHolder;
import org.msgpack.value.holder.ValueHolder;
import org.msgpack.value.impl.CursorImpl;

public class MessageUnpacker
implements Closeable {
    private static final MessageBuffer EMPTY_BUFFER = MessageBuffer.wrap(new byte[0]);
    private final MessagePack.Config config;
    private MessageBufferInput in;
    private MessageBuffer buffer = EMPTY_BUFFER;
    private int position;
    private long totalReadBytes;
    private MessageBuffer secondaryBuffer = null;
    private final MessageBuffer extraBuffer = MessageBuffer.wrap(new byte[24]);
    private boolean reachedEOF = false;
    private CharsetDecoder decoder;
    private CharBuffer decodeBuffer;
    private static final String EMPTY_STRING = "";

    public Cursor getCursor() {
        return new CursorImpl(this);
    }

    public MessageUnpacker(MessageBufferInput messageBufferInput) {
        this(messageBufferInput, MessagePack.DEFAULT_CONFIG);
    }

    public MessageUnpacker(MessageBufferInput messageBufferInput, MessagePack.Config config) {
        this.in = Preconditions.checkNotNull(messageBufferInput, "MessageBufferInput is null");
        this.config = Preconditions.checkNotNull(config, "Config");
    }

    public void reset(MessageBufferInput messageBufferInput) throws IOException {
        MessageBufferInput messageBufferInput2 = Preconditions.checkNotNull(messageBufferInput, "MessageBufferInput is null");
        this.close();
        this.in = messageBufferInput2;
        this.buffer = EMPTY_BUFFER;
        this.position = 0;
        this.totalReadBytes = 0L;
        this.secondaryBuffer = null;
        this.reachedEOF = false;
    }

    public long getTotalReadBytes() {
        return this.totalReadBytes + (long)this.position;
    }

    private void prepareDecoder() {
        if (this.decoder == null) {
            this.decodeBuffer = CharBuffer.allocate(this.config.getStringDecoderBufferSize());
            this.decoder = MessagePack.UTF8.newDecoder().onMalformedInput(this.config.getActionOnMalFormedInput()).onUnmappableCharacter(this.config.getActionOnUnmappableCharacter());
        }
    }

    private boolean ensureBuffer() throws IOException {
        while (this.buffer != null && this.position >= this.buffer.size()) {
            int n = this.buffer.size();
            this.position -= n;
            this.totalReadBytes += (long)n;
            this.buffer = this.takeNextBuffer();
        }
        return this.buffer != null;
    }

    private MessageBuffer takeNextBuffer() throws IOException {
        if (this.reachedEOF) {
            return null;
        }
        MessageBuffer messageBuffer = null;
        if (this.secondaryBuffer == null) {
            messageBuffer = this.in.next();
        } else {
            messageBuffer = this.secondaryBuffer;
            this.secondaryBuffer = null;
        }
        if (messageBuffer == null) {
            this.reachedEOF = true;
        }
        return messageBuffer;
    }

    private boolean ensure(int n) throws IOException {
        int n2;
        if (n == 0) {
            return true;
        }
        if (!this.ensureBuffer()) {
            return false;
        }
        if (this.position + n <= this.buffer.size()) {
            return true;
        }
        MessageBuffer messageBuffer = n <= this.extraBuffer.size() ? this.extraBuffer : MessageBuffer.newBuffer(n);
        int n3 = this.buffer.size() - this.position;
        if (n3 > 0) {
            this.buffer.copyTo(this.position, messageBuffer, 0, n3);
        }
        for (int i = n3; i < n; i += n2) {
            this.secondaryBuffer = this.takeNextBuffer();
            if (this.secondaryBuffer == null) {
                return false;
            }
            n2 = Math.min(n - i, this.secondaryBuffer.size());
            this.secondaryBuffer.copyTo(0, messageBuffer, i, n2);
            this.secondaryBuffer = n2 == this.secondaryBuffer.size() ? null : this.secondaryBuffer.slice(n2, this.secondaryBuffer.size() - n2);
        }
        this.totalReadBytes += (long)this.position;
        this.buffer = n == messageBuffer.size() ? messageBuffer : messageBuffer.slice(0, n);
        this.position = 0;
        return true;
    }

    public boolean hasNext() throws IOException {
        return this.ensure(1);
    }

    public MessageFormat getNextFormat() throws IOException {
        byte by = this.lookAhead();
        return MessageFormat.valueOf(by);
    }

    private byte lookAhead() throws IOException {
        if (this.ensure(1)) {
            return this.buffer.getByte(this.position);
        }
        throw new EOFException();
    }

    private byte consume() throws IOException {
        byte by = this.lookAhead();
        ++this.position;
        return by;
    }

    private void consume(int n) throws IOException {
        assert (n >= 0);
        if (this.position + n < 0) {
            this.ensureBuffer();
        }
        this.position += n;
    }

    private byte readByte() throws IOException {
        if (!this.ensure(1)) {
            throw new EOFException("insufficient data length for reading byte value");
        }
        byte by = this.buffer.getByte(this.position);
        this.consume(1);
        return by;
    }

    private short readShort() throws IOException {
        if (!this.ensure(2)) {
            throw new EOFException("insufficient data length for reading short value");
        }
        short s = this.buffer.getShort(this.position);
        this.consume(2);
        return s;
    }

    private int readInt() throws IOException {
        if (!this.ensure(4)) {
            throw new EOFException("insufficient data length for reading int value");
        }
        int n = this.buffer.getInt(this.position);
        this.consume(4);
        return n;
    }

    private float readFloat() throws IOException {
        if (!this.ensure(4)) {
            throw new EOFException("insufficient data length for reading float value");
        }
        float f = this.buffer.getFloat(this.position);
        this.consume(4);
        return f;
    }

    private long readLong() throws IOException {
        if (!this.ensure(8)) {
            throw new EOFException("insufficient data length for reading long value");
        }
        long l = this.buffer.getLong(this.position);
        this.consume(8);
        return l;
    }

    private double readDouble() throws IOException {
        if (!this.ensure(8)) {
            throw new EOFException("insufficient data length for reading double value");
        }
        double d = this.buffer.getDouble(this.position);
        this.consume(8);
        return d;
    }

    public void skipBytes(int n) throws IOException {
        Preconditions.checkArgument(n >= 0, "skip length must be >= 0: " + n);
        this.consume(n);
    }

    public void skipValue() throws IOException {
        block26: for (int i = 1; i > 0; --i) {
            if (this.reachedEOF) {
                throw new EOFException();
            }
            MessageFormat messageFormat = this.getNextFormat();
            byte by = this.consume();
            switch (messageFormat) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    continue block26;
                }
                case FIXMAP: {
                    int n = by & 0xF;
                    i += n * 2;
                    continue block26;
                }
                case FIXARRAY: {
                    int n = by & 0xF;
                    i += n;
                    continue block26;
                }
                case FIXSTR: {
                    int n = by & 0x1F;
                    this.consume(n);
                    continue block26;
                }
                case INT8: 
                case UINT8: {
                    this.consume(1);
                    continue block26;
                }
                case INT16: 
                case UINT16: {
                    this.consume(2);
                    continue block26;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.consume(4);
                    continue block26;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.consume(8);
                    continue block26;
                }
                case BIN8: 
                case STR8: {
                    this.consume(this.readNextLength8());
                    continue block26;
                }
                case BIN16: 
                case STR16: {
                    this.consume(this.readNextLength16());
                    continue block26;
                }
                case BIN32: 
                case STR32: {
                    this.consume(this.readNextLength32());
                    continue block26;
                }
                case FIXEXT1: {
                    this.consume(2);
                    continue block26;
                }
                case FIXEXT2: {
                    this.consume(3);
                    continue block26;
                }
                case FIXEXT4: {
                    this.consume(5);
                    continue block26;
                }
                case FIXEXT8: {
                    this.consume(9);
                    continue block26;
                }
                case FIXEXT16: {
                    this.consume(17);
                    continue block26;
                }
                case EXT8: {
                    this.consume(this.readNextLength8() + 1);
                    continue block26;
                }
                case EXT16: {
                    this.consume(this.readNextLength16() + 1);
                    continue block26;
                }
                case EXT32: {
                    this.consume(this.readNextLength32() + 1);
                    continue block26;
                }
                case ARRAY16: {
                    i += this.readNextLength16();
                    this.consume(2);
                    continue block26;
                }
                case ARRAY32: {
                    i += this.readNextLength32();
                    this.consume(4);
                    continue block26;
                }
                case MAP16: {
                    i += this.readNextLength16() * 2;
                    this.consume(2);
                    continue block26;
                }
                case MAP32: {
                    i += this.readNextLength32() * 2;
                    this.consume(2);
                    continue block26;
                }
                case NEVER_USED: {
                    throw new MessageFormatException(String.format("unknown code: %02x is found", by));
                }
            }
        }
    }

    private static MessageTypeException unexpected(String string, byte by) throws MessageTypeException {
        ValueType valueType = ValueType.valueOf(by);
        return new MessageTypeException(String.format("Expected %s, but got %s (%02x)", string, valueType.toTypeName(), by));
    }

    public MessageFormat unpackValue(ValueHolder valueHolder) throws IOException {
        MessageFormat messageFormat = this.getNextFormat();
        switch (messageFormat.getValueType()) {
            case NIL: {
                this.unpackNil();
                valueHolder.setNil();
                break;
            }
            case BOOLEAN: {
                valueHolder.setBoolean(this.unpackBoolean());
                break;
            }
            case INTEGER: {
                this.unpackInteger(valueHolder.getIntegerHolder());
                valueHolder.setToInteger();
                break;
            }
            case FLOAT: {
                this.unpackFloat(valueHolder.getFloatHolder());
                valueHolder.setToFloat();
                break;
            }
            case STRING: {
                int n = this.unpackRawStringHeader();
                valueHolder.setString(this.readPayloadAsReference(n));
                break;
            }
            case BINARY: {
                int n = this.unpackBinaryHeader();
                valueHolder.setBinary(this.readPayloadAsReference(n));
                break;
            }
            case ARRAY: {
                valueHolder.prepareArrayCursor(this);
                break;
            }
            case MAP: {
                valueHolder.prepareMapCursor(this);
                break;
            }
            case EXTENDED: {
                ExtendedTypeHeader extendedTypeHeader = this.unpackExtendedTypeHeader();
                valueHolder.setExt(extendedTypeHeader.getType(), this.readPayloadAsReference(extendedTypeHeader.getLength()));
            }
        }
        return messageFormat;
    }

    public Object unpackNil() throws IOException {
        byte by = this.consume();
        if (by == -64) {
            return null;
        }
        throw MessageUnpacker.unexpected("Nil", by);
    }

    public boolean unpackBoolean() throws IOException {
        byte by = this.consume();
        if (by == -62) {
            return false;
        }
        if (by == -61) {
            return true;
        }
        throw MessageUnpacker.unexpected("boolean", by);
    }

    public byte unpackByte() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                if (by2 < 0) {
                    throw MessageUnpacker.overflowU8(by2);
                }
                return by2;
            }
            case -51: {
                short s = this.readShort();
                if (s < 0 || s > 127) {
                    throw MessageUnpacker.overflowU16(s);
                }
                return (byte)s;
            }
            case -50: {
                int n = this.readInt();
                if (n < 0 || n > 127) {
                    throw MessageUnpacker.overflowU32(n);
                }
                return (byte)n;
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L || l > 127L) {
                    throw MessageUnpacker.overflowU64(l);
                }
                return (byte)l;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s = this.readShort();
                if (s < -128 || s > 127) {
                    throw MessageUnpacker.overflowI16(s);
                }
                return (byte)s;
            }
            case -46: {
                int n = this.readInt();
                if (n < -128 || n > 127) {
                    throw MessageUnpacker.overflowI32(n);
                }
                return (byte)n;
            }
            case -45: {
                long l = this.readLong();
                if (l < -128L || l > 127L) {
                    throw MessageUnpacker.overflowI64(l);
                }
                return (byte)l;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public short unpackShort() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return (short)(by2 & 0xFF);
            }
            case -51: {
                short s = this.readShort();
                if (s < 0) {
                    throw MessageUnpacker.overflowU16(s);
                }
                return s;
            }
            case -50: {
                int n = this.readInt();
                if (n < 0 || n > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowU32(n);
                }
                return (short)n;
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L || l > 32767L) {
                    throw MessageUnpacker.overflowU64(l);
                }
                return (short)l;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s = this.readShort();
                return s;
            }
            case -46: {
                int n = this.readInt();
                if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                    throw MessageUnpacker.overflowI32(n);
                }
                return (short)n;
            }
            case -45: {
                long l = this.readLong();
                if (l < -32768L || l > 32767L) {
                    throw MessageUnpacker.overflowI64(l);
                }
                return (short)l;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public int unpackInt() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return by2 & 0xFF;
            }
            case -51: {
                short s = this.readShort();
                return s & 0xFFFF;
            }
            case -50: {
                int n = this.readInt();
                if (n < 0) {
                    throw MessageUnpacker.overflowU32(n);
                }
                return n;
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L || l > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowU64(l);
                }
                return (int)l;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s = this.readShort();
                return s;
            }
            case -46: {
                int n = this.readInt();
                return n;
            }
            case -45: {
                long l = this.readLong();
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw MessageUnpacker.overflowI64(l);
                }
                return (int)l;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public long unpackLong() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            return by;
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return by2 & 0xFF;
            }
            case -51: {
                short s = this.readShort();
                return s & 0xFFFF;
            }
            case -50: {
                int n = this.readInt();
                if (n < 0) {
                    return (long)(n & Integer.MAX_VALUE) + 0x80000000L;
                }
                return n;
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L) {
                    throw MessageUnpacker.overflowU64(l);
                }
                return l;
            }
            case -48: {
                byte by3 = this.readByte();
                return by3;
            }
            case -47: {
                short s = this.readShort();
                return s;
            }
            case -46: {
                int n = this.readInt();
                return n;
            }
            case -45: {
                long l = this.readLong();
                return l;
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public BigInteger unpackBigInteger() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            return BigInteger.valueOf(by);
        }
        switch (by) {
            case -52: {
                byte by2 = this.readByte();
                return BigInteger.valueOf(by2 & 0xFF);
            }
            case -51: {
                short s = this.readShort();
                return BigInteger.valueOf(s & 0xFFFF);
            }
            case -50: {
                int n = this.readInt();
                if (n < 0) {
                    return BigInteger.valueOf((long)(n & Integer.MAX_VALUE) + 0x80000000L);
                }
                return BigInteger.valueOf(n);
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(l + Long.MAX_VALUE + 1L).setBit(63);
                    return bigInteger;
                }
                return BigInteger.valueOf(l);
            }
            case -48: {
                byte by3 = this.readByte();
                return BigInteger.valueOf(by3);
            }
            case -47: {
                short s = this.readShort();
                return BigInteger.valueOf(s);
            }
            case -46: {
                int n = this.readInt();
                return BigInteger.valueOf(n);
            }
            case -45: {
                long l = this.readLong();
                return BigInteger.valueOf(l);
            }
        }
        throw MessageUnpacker.unexpected("Integer", by);
    }

    public void unpackInteger(IntegerHolder integerHolder) throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixInt(by)) {
            integerHolder.setByte(by);
            return;
        }
        switch (by) {
            case -48: {
                integerHolder.setByte(this.readByte());
                break;
            }
            case -47: {
                integerHolder.setShort(this.readShort());
                break;
            }
            case -46: {
                integerHolder.setInt(this.readInt());
                break;
            }
            case -45: {
                integerHolder.setLong(this.readLong());
                break;
            }
            case -52: {
                byte by2 = this.readByte();
                if (by2 < 0) {
                    integerHolder.setShort((short)(by2 & 0xFF));
                    break;
                }
                integerHolder.setByte(by2);
                break;
            }
            case -51: {
                short s = this.readShort();
                if (s < 0) {
                    integerHolder.setInt(s & 0xFFFF);
                    break;
                }
                integerHolder.setShort(s);
                break;
            }
            case -50: {
                int n = this.readInt();
                if (n < 0) {
                    integerHolder.setLong((long)(n & Integer.MAX_VALUE) + 0x80000000L);
                    break;
                }
                integerHolder.setInt(n);
                break;
            }
            case -49: {
                long l = this.readLong();
                if (l < 0L) {
                    integerHolder.setBigInteger(BigInteger.valueOf(l + Long.MAX_VALUE + 1L).setBit(63));
                    break;
                }
                integerHolder.setLong(l);
                break;
            }
            default: {
                throw MessageUnpacker.unexpected("Integer", by);
            }
        }
    }

    public float unpackFloat() throws IOException {
        byte by = this.consume();
        switch (by) {
            case -54: {
                float f = this.readFloat();
                return f;
            }
            case -53: {
                double d = this.readDouble();
                return (float)d;
            }
        }
        throw MessageUnpacker.unexpected("Float", by);
    }

    public double unpackDouble() throws IOException {
        byte by = this.consume();
        switch (by) {
            case -54: {
                float f = this.readFloat();
                return f;
            }
            case -53: {
                double d = this.readDouble();
                return d;
            }
        }
        throw MessageUnpacker.unexpected("Float", by);
    }

    public void unpackFloat(ValueHolder valueHolder) throws IOException {
        this.unpackFloat(valueHolder.getFloatHolder());
    }

    public void unpackFloat(FloatHolder floatHolder) throws IOException {
        byte by = this.consume();
        switch (by) {
            case -54: {
                float f = this.readFloat();
                floatHolder.setFloat(f);
                break;
            }
            case -53: {
                double d = this.readDouble();
                floatHolder.setDouble(d);
                break;
            }
            default: {
                throw MessageUnpacker.unexpected("Float", by);
            }
        }
    }

    public String unpackString() throws IOException {
        int n = this.unpackRawStringHeader();
        if (n > 0) {
            if (n > this.config.getMaxUnpackStringSize()) {
                throw new MessageSizeException(String.format("cannot unpack a String of size larger than %,d: %,d", this.config.getMaxUnpackStringSize(), n), n);
            }
            this.prepareDecoder();
            assert (this.decoder != null);
            this.decoder.reset();
            try {
                int n2 = 0;
                this.decodeBuffer.clear();
                StringBuilder stringBuilder = new StringBuilder();
                while (n2 < n) {
                    if (!this.ensureBuffer()) {
                        throw new EOFException();
                    }
                    int n3 = Math.min(this.buffer.size() - this.position, n - n2);
                    ByteBuffer byteBuffer = this.buffer.toByteBuffer(this.position, n3);
                    while (byteBuffer.hasRemaining()) {
                        boolean bl = n2 + n3 >= n;
                        CoderResult coderResult = this.decoder.decode(byteBuffer, this.decodeBuffer, bl);
                        if (bl && coderResult.isUnderflow()) {
                            coderResult = this.decoder.flush(this.decodeBuffer);
                        }
                        if (coderResult.isOverflow()) {
                            n3 = byteBuffer.limit() - byteBuffer.remaining();
                            this.decoder.reset();
                        }
                        if (coderResult.isError() && (coderResult.isMalformed() && this.config.getActionOnMalFormedInput() == CodingErrorAction.REPORT || coderResult.isUnmappable() && this.config.getActionOnUnmappableCharacter() == CodingErrorAction.REPORT)) {
                            coderResult.throwException();
                        }
                        this.decodeBuffer.flip();
                        stringBuilder.append(this.decodeBuffer);
                        this.decodeBuffer.clear();
                        n2 += n3;
                        this.consume(n3);
                    }
                }
                return stringBuilder.toString();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new MessageStringCodingException(characterCodingException);
            }
        }
        return EMPTY_STRING;
    }

    public int unpackArrayHeader() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixedArray(by)) {
            return by & 0xF;
        }
        switch (by) {
            case -36: {
                return this.readNextLength16();
            }
            case -35: {
                return this.readNextLength32();
            }
        }
        throw MessageUnpacker.unexpected("Array", by);
    }

    public int unpackMapHeader() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixedMap(by)) {
            return by & 0xF;
        }
        switch (by) {
            case -34: {
                return this.readNextLength16();
            }
            case -33: {
                return this.readNextLength32();
            }
        }
        throw MessageUnpacker.unexpected("Map", by);
    }

    public ExtendedTypeHeader unpackExtendedTypeHeader() throws IOException {
        byte by = this.consume();
        switch (by) {
            case -44: {
                return new ExtendedTypeHeader(1, this.readByte());
            }
            case -43: {
                return new ExtendedTypeHeader(2, this.readByte());
            }
            case -42: {
                return new ExtendedTypeHeader(4, this.readByte());
            }
            case -41: {
                return new ExtendedTypeHeader(8, this.readByte());
            }
            case -40: {
                return new ExtendedTypeHeader(16, this.readByte());
            }
            case -57: {
                int n = this.readNextLength8();
                byte by2 = this.readByte();
                return new ExtendedTypeHeader(n, by2);
            }
            case -56: {
                int n = this.readNextLength16();
                byte by3 = this.readByte();
                return new ExtendedTypeHeader(n, by3);
            }
            case -55: {
                int n = this.readNextLength32();
                byte by4 = this.readByte();
                return new ExtendedTypeHeader(n, by4);
            }
        }
        throw MessageUnpacker.unexpected("Ext", by);
    }

    private int readStringHeader(byte by) throws IOException {
        switch (by) {
            case -39: {
                return this.readNextLength8();
            }
            case -38: {
                return this.readNextLength16();
            }
            case -37: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    private int readBinaryHeader(byte by) throws IOException {
        switch (by) {
            case -60: {
                return this.readNextLength8();
            }
            case -59: {
                return this.readNextLength16();
            }
            case -58: {
                return this.readNextLength32();
            }
        }
        return -1;
    }

    public int unpackRawStringHeader() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixedRaw(by)) {
            return by & 0x1F;
        }
        int n = this.readStringHeader(by);
        if (n >= 0) {
            return n;
        }
        if (this.config.isReadBinaryAsString() && (n = this.readBinaryHeader(by)) >= 0) {
            return n;
        }
        throw MessageUnpacker.unexpected("String", by);
    }

    public int unpackBinaryHeader() throws IOException {
        byte by = this.consume();
        if (MessagePack.Code.isFixedRaw(by)) {
            return by & 0x1F;
        }
        int n = this.readBinaryHeader(by);
        if (n >= 0) {
            return n;
        }
        if (this.config.isReadStringAsBinary() && (n = this.readStringHeader(by)) >= 0) {
            return n;
        }
        throw MessageUnpacker.unexpected("Binary", by);
    }

    public void readPayload(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.remaining() > 0) {
            if (!this.ensureBuffer()) {
                throw new EOFException();
            }
            int n = Math.min(this.buffer.size() - this.position, byteBuffer.remaining());
            this.buffer.getBytes(this.position, n, byteBuffer);
            this.consume(n);
        }
    }

    public void readPayload(byte[] byArray) throws IOException {
        this.readPayload(byArray, 0, byArray.length);
    }

    public void readPayload(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            if (!this.ensureBuffer()) {
                throw new EOFException();
            }
            n3 = Math.min(this.buffer.size() - this.position, n2 - i);
            this.buffer.getBytes(this.position, byArray, n + i, n3);
            this.consume(n3);
        }
    }

    public MessageBuffer readPayloadAsReference(int n) throws IOException {
        Preconditions.checkArgument(n >= 0);
        if (!this.ensure(n)) {
            throw new EOFException();
        }
        MessageBuffer messageBuffer = this.buffer.slice(this.position, n);
        this.position += n;
        return messageBuffer;
    }

    private int readNextLength8() throws IOException {
        byte by = this.readByte();
        return by & 0xFF;
    }

    private int readNextLength16() throws IOException {
        short s = this.readShort();
        return s & 0xFFFF;
    }

    private int readNextLength32() throws IOException {
        int n = this.readInt();
        if (n < 0) {
            throw MessageUnpacker.overflowU32Size(n);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static MessageIntegerOverflowException overflowU8(byte by) {
        BigInteger bigInteger = BigInteger.valueOf(by & 0xFF);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU16(short s) {
        BigInteger bigInteger = BigInteger.valueOf(s & 0xFFFF);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU32(int n) {
        BigInteger bigInteger = BigInteger.valueOf((long)(n & Integer.MAX_VALUE) + 0x80000000L);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowU64(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l + Long.MAX_VALUE + 1L).setBit(63);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI16(short s) {
        BigInteger bigInteger = BigInteger.valueOf(s);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI32(int n) {
        BigInteger bigInteger = BigInteger.valueOf(n);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageIntegerOverflowException overflowI64(long l) {
        BigInteger bigInteger = BigInteger.valueOf(l);
        return new MessageIntegerOverflowException(bigInteger);
    }

    private static MessageSizeException overflowU32Size(int n) {
        long l = (long)(n & Integer.MAX_VALUE) + 0x80000000L;
        return new MessageSizeException(l);
    }
}

