/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageTypeException;
import org.msgpack.value.ArrayCursor;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueRef;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.AbstractValue;

public class ArrayValueImpl
extends AbstractValue
implements ArrayValue {
    private static ArrayValueImpl EMPTY = new ArrayValueImpl(new Value[0]);
    private int cursor = 0;
    private final Value[] array;

    public static ArrayValue empty() {
        return EMPTY;
    }

    public ArrayValueImpl(Value[] valueArray) {
        this.array = valueArray;
    }

    @Override
    public Value get(int n) {
        return this.array[n];
    }

    @Override
    public Value apply(int n) {
        return this.array[n];
    }

    @Override
    public ValueType getValueType() {
        return ValueType.ARRAY;
    }

    @Override
    public ArrayCursor getArrayCursor() throws MessageTypeException {
        return this;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packArrayHeader(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i].writeTo(messagePacker);
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitArray(this);
    }

    @Override
    public ArrayValue toValue() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isArray()) {
            return false;
        }
        Value[] valueArray = value.asArrayValue().toValueArray();
        if (this.array.length != valueArray.length) {
            return false;
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i].equals(valueArray[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.array.length; ++i) {
            Value value = this.array[i];
            n = 31 * n + value.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private StringBuilder toString(StringBuilder stringBuilder) {
        if (this.array.length == 0) {
            return stringBuilder.append("[]");
        }
        stringBuilder.append("[");
        stringBuilder.append(this.array[0]);
        for (int i = 1; i < this.array.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(this.array[i].toString());
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    @Override
    public ValueRef next() {
        return this.array[this.cursor++];
    }

    @Override
    public void skip() {
        ++this.cursor;
    }

    @Override
    public void skipAll() {
        while (this.hasNext()) {
            this.skip();
        }
    }

    @Override
    public Value[] toValueArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public Iterator<ValueRef> iterator() {
        return new Iterator<ValueRef>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < ArrayValueImpl.this.array.length;
            }

            @Override
            public ValueRef next() {
                return ArrayValueImpl.this.array[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

