/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class OutputStreamBufferOutput
implements MessageBufferOutput {
    private final OutputStream out;

    public OutputStreamBufferOutput(OutputStream outputStream) {
        this.out = Preconditions.checkNotNull(outputStream, "output is null");
    }

    @Override
    public void flush(MessageBuffer messageBuffer, int n, int n2) throws IOException {
        assert (n + n2 < messageBuffer.size());
        byte[] byArray = new byte[n2];
        messageBuffer.getBytes(n, byArray, 0, n2);
        this.out.write(byArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.out.flush();
        }
        finally {
            this.out.close();
        }
    }
}

