/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.msgpack.core.Preconditions;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class MessageBuffer {
    static final Unsafe unsafe;
    static final Constructor byteBufferConstructor;
    static final boolean isByteBufferConstructorTakesBufferReference;
    static final int ARRAY_BYTE_BASE_OFFSET;
    static final int ARRAY_BYTE_INDEX_SCALE;
    private static final Class<?> msgBufferClass;
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    static MessageBuffer newOffHeapBuffer(int n) {
        long l = unsafe.allocateMemory(n);
        return new MessageBuffer(l, n);
    }

    public static MessageBuffer newDirectBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        return MessageBuffer.newMessageBuffer(byteBuffer);
    }

    public static MessageBuffer newBuffer(int n) {
        return MessageBuffer.newMessageBuffer(new byte[n]);
    }

    public static MessageBuffer wrap(byte[] byArray) {
        return MessageBuffer.newMessageBuffer(byArray);
    }

    public static MessageBuffer wrap(ByteBuffer byteBuffer) {
        return MessageBuffer.newMessageBuffer(byteBuffer);
    }

    private static MessageBuffer newMessageBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        try {
            Constructor<?> constructor = msgBufferClass.getDeclaredConstructor(ByteBuffer.class);
            return (MessageBuffer)constructor.newInstance(byteBuffer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static MessageBuffer newMessageBuffer(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        try {
            Constructor<?> constructor = msgBufferClass.getDeclaredConstructor(byte[].class);
            return (MessageBuffer)constructor.newInstance(new Object[]{byArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void releaseBuffer(MessageBuffer messageBuffer) {
        if (!(messageBuffer.base instanceof byte[])) {
            if (messageBuffer.base instanceof DirectBuffer) {
                ((DirectBuffer)messageBuffer.base).cleaner().clean();
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    MessageBuffer(long l, int n) {
        this.base = null;
        this.address = l;
        this.size = n;
        this.reference = null;
    }

    MessageBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer directBuffer = (DirectBuffer)DirectBuffer.class.cast(byteBuffer);
            this.base = null;
            this.address = directBuffer.address();
            this.size = byteBuffer.capacity();
            this.reference = byteBuffer;
        } else if (byteBuffer.hasArray()) {
            this.base = byteBuffer.array();
            this.address = ARRAY_BYTE_BASE_OFFSET;
            this.size = byteBuffer.array().length;
            this.reference = null;
        } else {
            throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer are supported");
        }
    }

    MessageBuffer(byte[] byArray) {
        this.base = byArray;
        this.address = ARRAY_BYTE_BASE_OFFSET;
        this.size = byArray.length;
        this.reference = null;
    }

    protected MessageBuffer(Object object, long l, int n, ByteBuffer byteBuffer) {
        this.base = object;
        this.address = l;
        this.size = n;
        this.reference = byteBuffer;
    }

    public int size() {
        return this.size;
    }

    public MessageBuffer slice(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n + n2 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)n, n2, this.reference);
    }

    public byte getByte(int n) {
        return unsafe.getByte(this.base, this.address + (long)n);
    }

    public boolean getBoolean(int n) {
        return unsafe.getBoolean(this.base, this.address + (long)n);
    }

    public short getShort(int n) {
        short s = unsafe.getShort(this.base, this.address + (long)n);
        return Short.reverseBytes(s);
    }

    public int getInt(int n) {
        int n2 = unsafe.getInt(this.base, this.address + (long)n);
        return Integer.reverseBytes(n2);
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public long getLong(int n) {
        long l = unsafe.getLong(this.base, this.address + (long)n);
        return Long.reverseBytes(l);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, byArray, ARRAY_BYTE_BASE_OFFSET + n2, n3);
    }

    public void getBytes(int n, int n2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() > n2) {
            throw new BufferOverflowException();
        }
        ByteBuffer byteBuffer2 = this.toByteBuffer(n, n2);
        byteBuffer.put(byteBuffer2);
    }

    public void putByte(int n, byte by) {
        unsafe.putByte(this.base, this.address + (long)n, by);
    }

    public void putBoolean(int n, boolean bl) {
        unsafe.putBoolean(this.base, this.address + (long)n, bl);
    }

    public void putShort(int n, short s) {
        s = Short.reverseBytes(s);
        unsafe.putShort(this.base, this.address + (long)n, s);
    }

    public void putInt(int n, int n2) {
        n2 = Integer.reverseBytes(n2);
        unsafe.putInt(this.base, this.address + (long)n, n2);
    }

    public void putFloat(int n, float f) {
        this.putInt(n, Float.floatToRawIntBits(f));
    }

    public void putLong(int n, long l) {
        l = Long.reverseBytes(l);
        unsafe.putLong(this.base, this.address + (long)n, l);
    }

    public void putDouble(int n, double d) {
        this.putLong(n, Double.doubleToRawLongBits(d));
    }

    public void putBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + n2, this.base, this.address + (long)n, n3);
    }

    public void putByteBuffer(int n, ByteBuffer byteBuffer, int n2) {
        assert (n2 <= byteBuffer.remaining());
        if (byteBuffer.isDirect()) {
            DirectBuffer directBuffer = (DirectBuffer)((Object)byteBuffer);
            unsafe.copyMemory(null, directBuffer.address() + (long)byteBuffer.position(), this.base, this.address + (long)n, n2);
        } else if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + byteBuffer.position(), this.base, this.address + (long)n, n2);
        } else if (this.base != null) {
            byteBuffer.get((byte[])this.base, n, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                unsafe.putByte(this.base, this.address + (long)n, byteBuffer.get());
            }
        }
        byteBuffer.position(byteBuffer.position() + n2);
    }

    public ByteBuffer toByteBuffer(int n, int n2) {
        if (this.base instanceof byte[]) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)n), n2);
        }
        try {
            if (isByteBufferConstructorTakesBufferReference) {
                return (ByteBuffer)byteBufferConstructor.newInstance(this.address + (long)n, n2, this.reference);
            }
            return (ByteBuffer)byteBufferConstructor.newInstance(this.address + (long)n, n2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size());
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        unsafe.copyMemory(this.base, this.address, byArray, ARRAY_BYTE_BASE_OFFSET, this.size());
        return byArray;
    }

    public void relocate(int n, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, this.base, this.address + (long)n3, n2);
    }

    public void copyTo(int n, MessageBuffer messageBuffer, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, messageBuffer.base, messageBuffer.address + (long)n2, n3);
    }

    public String toHexString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            if (i != n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02x", this.getByte(i)));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            Constructor constructor;
            Unsafe unsafe;
            AnnotatedElement annotatedElement;
            try {
                annotatedElement = Unsafe.class.getDeclaredField("theUnsafe");
                ((Field)annotatedElement).setAccessible(true);
                unsafe = (Unsafe)((Field)annotatedElement).get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                constructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                unsafe = (Unsafe)constructor.newInstance(new Object[0]);
            }
            MessageBuffer.unsafe = unsafe;
            if (MessageBuffer.unsafe == null) {
                throw new RuntimeException("Unsafe is unavailable");
            }
            ARRAY_BYTE_BASE_OFFSET = MessageBuffer.unsafe.arrayBaseOffset(byte[].class);
            ARRAY_BYTE_INDEX_SCALE = MessageBuffer.unsafe.arrayIndexScale(byte[].class);
            if (ARRAY_BYTE_INDEX_SCALE != 1) {
                throw new IllegalStateException("Byte array index scale must be 1, but is " + ARRAY_BYTE_INDEX_SCALE);
            }
            annotatedElement = ClassLoader.getSystemClassLoader().loadClass("java.nio.DirectByteBuffer");
            constructor = null;
            boolean bl = true;
            try {
                constructor = ((Class)annotatedElement).getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = ((Class)annotatedElement).getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                bl = true;
            }
            byteBufferConstructor = constructor;
            isByteBufferConstructorTakesBufferReference = bl;
            if (byteBufferConstructor == null) {
                throw new RuntimeException("Constructor of DirectByteBuffer is not found");
            }
            byteBufferConstructor.setAccessible(true);
            boolean bl2 = true;
            byte[] byArray = new byte[8];
            MessageBuffer.unsafe.putLong(byArray, ARRAY_BYTE_BASE_OFFSET, 72623859790382856L);
            switch (byArray[0]) {
                case 1: {
                    bl2 = false;
                    break;
                }
                case 8: {
                    bl2 = true;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            String string = bl2 ? "org.msgpack.core.buffer.MessageBuffer" : "org.msgpack.core.buffer.MessageBufferBE";
            msgBufferClass = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
    }
}

