/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class InputStreamBufferInput
implements MessageBufferInput {
    private static Field bufField = InputStreamBufferInput.getField("buf");
    private static Field bufPosField = InputStreamBufferInput.getField("pos");
    private static Field bufCountField = InputStreamBufferInput.getField("count");
    private final InputStream in;
    private final int bufferSize;
    private boolean reachedEOF = false;

    private static Field getField(String string) {
        Field field = null;
        try {
            field = ByteArrayInputStream.class.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return field;
    }

    public static MessageBufferInput newBufferInput(InputStream inputStream) {
        Preconditions.checkNotNull(inputStream, "InputStream is null");
        if (inputStream.getClass() == ByteArrayInputStream.class) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
            try {
                byte[] byArray = (byte[])bufField.get(byteArrayInputStream);
                int n = (Integer)bufPosField.get(byteArrayInputStream);
                int n2 = (Integer)bufCountField.get(byteArrayInputStream);
                return new ArrayBufferInput(byArray, n, n2);
            }
            catch (Exception exception) {}
        } else if (inputStream instanceof FileInputStream) {
            return new ChannelBufferInput(((FileInputStream)inputStream).getChannel());
        }
        return new InputStreamBufferInput(inputStream);
    }

    public InputStreamBufferInput(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public InputStreamBufferInput(InputStream inputStream, int n) {
        this.in = Preconditions.checkNotNull(inputStream, "input is null");
        this.bufferSize = n;
    }

    @Override
    public MessageBuffer next() throws IOException {
        int n;
        int n2;
        if (this.reachedEOF) {
            return null;
        }
        byte[] byArray = null;
        for (n = 0; !this.reachedEOF && n < this.bufferSize; n += n2) {
            if (byArray == null) {
                byArray = new byte[this.bufferSize];
            }
            if ((n2 = this.in.read(byArray, n, this.bufferSize - n)) != -1) continue;
            this.reachedEOF = true;
            break;
        }
        return byArray == null ? null : MessageBuffer.wrap(byArray).slice(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

