/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;

public class ChannelBufferOutput
implements MessageBufferOutput {
    private final WritableByteChannel channel;

    public ChannelBufferOutput(WritableByteChannel writableByteChannel) {
        this.channel = Preconditions.checkNotNull(writableByteChannel, "output channel is null");
    }

    @Override
    public void flush(MessageBuffer messageBuffer, int n, int n2) throws IOException {
        assert (n + n2 < messageBuffer.size());
        ByteBuffer byteBuffer = messageBuffer.toByteBuffer(n, n2);
        this.channel.write(byteBuffer);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

