/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;
import org.msgpack.value.Value;

public class MessagePacker
implements Closeable {
    private final MessagePack.Config config;
    private final MessageBufferOutput out;
    private final MessageBuffer buffer;
    private int position;
    private ByteBuffer encodeBuffer;
    private CharsetEncoder encoder;

    public MessagePacker(OutputStream outputStream) {
        this(new OutputStreamBufferOutput(outputStream));
    }

    public MessagePacker(MessageBufferOutput messageBufferOutput) {
        this(messageBufferOutput, MessagePack.DEFAULT_CONFIG);
    }

    public MessagePacker(MessageBufferOutput messageBufferOutput, MessagePack.Config config) {
        this.config = Preconditions.checkNotNull(config, "config is null");
        this.out = Preconditions.checkNotNull(messageBufferOutput, "MessageBufferOutput is null");
        this.buffer = MessageBuffer.newDirectBuffer(config.getPackerBufferSize());
        this.position = 0;
    }

    private void prepareEncoder() {
        if (this.encoder == null) {
            this.encodeBuffer = ByteBuffer.allocate(this.config.getStringEncoderBufferSize());
            this.encoder = MessagePack.UTF8.newEncoder().onMalformedInput(this.config.getActionOnMalFormedInput()).onUnmappableCharacter(this.config.getActionOnMalFormedInput());
        }
    }

    public void flush() throws IOException {
        this.out.flush(this.buffer, 0, this.position);
        this.position = 0;
    }

    private void flushBuffer(MessageBuffer messageBuffer) throws IOException {
        this.out.flush(messageBuffer, 0, messageBuffer.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }

    private void ensureCapacity(int n) throws IOException {
        if (this.position + n < this.buffer.size()) {
            return;
        }
        this.flush();
    }

    private void writeByte(byte by) throws IOException {
        this.ensureCapacity(1);
        this.buffer.putByte(this.position++, by);
    }

    private void writeByteAndByte(byte by, byte by2) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putByte(this.position++, by);
        this.buffer.putByte(this.position++, by2);
    }

    private void writeByteAndShort(byte by, short s) throws IOException {
        this.ensureCapacity(3);
        this.buffer.putByte(this.position++, by);
        this.buffer.putShort(this.position, s);
        this.position += 2;
    }

    private void writeByteAndInt(byte by, int n) throws IOException {
        this.ensureCapacity(5);
        this.buffer.putByte(this.position++, by);
        this.buffer.putInt(this.position, n);
        this.position += 4;
    }

    private void writeByteAndFloat(byte by, float f) throws IOException {
        this.ensureCapacity(5);
        this.buffer.putByte(this.position++, by);
        this.buffer.putFloat(this.position, f);
        this.position += 4;
    }

    private void writeByteAndDouble(byte by, double d) throws IOException {
        this.ensureCapacity(9);
        this.buffer.putByte(this.position++, by);
        this.buffer.putDouble(this.position, d);
        this.position += 8;
    }

    private void writeByteAndLong(byte by, long l) throws IOException {
        this.ensureCapacity(9);
        this.buffer.putByte(this.position++, by);
        this.buffer.putLong(this.position, l);
        this.position += 8;
    }

    private void writeShort(short s) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putShort(this.position, s);
        this.position += 2;
    }

    private void writeInt(int n) throws IOException {
        this.ensureCapacity(4);
        this.buffer.putInt(this.position, n);
        this.position += 4;
    }

    private void writeLong(long l) throws IOException {
        this.ensureCapacity(8);
        this.buffer.putLong(this.position, l);
        this.position += 8;
    }

    public MessagePacker packNil() throws IOException {
        this.writeByte((byte)-64);
        return this;
    }

    public MessagePacker packBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? (byte)-61 : -62);
        return this;
    }

    public MessagePacker packByte(byte by) throws IOException {
        if (by < -32) {
            this.writeByteAndByte((byte)-48, by);
        } else {
            this.writeByte(by);
        }
        return this;
    }

    public MessagePacker packShort(short s) throws IOException {
        if (s < -32) {
            if (s < -128) {
                this.writeByteAndShort((byte)-47, s);
            } else {
                this.writeByteAndByte((byte)-48, (byte)s);
            }
        } else if (s < 128) {
            this.writeByte((byte)s);
        } else if (s < 256) {
            this.writeByteAndByte((byte)-52, (byte)s);
        } else {
            this.writeByteAndShort((byte)-51, s);
        }
        return this;
    }

    public MessagePacker packInt(int n) throws IOException {
        if (n < -32) {
            if (n < Short.MIN_VALUE) {
                this.writeByteAndInt((byte)-46, n);
            } else if (n < -128) {
                this.writeByteAndShort((byte)-47, (short)n);
            } else {
                this.writeByteAndByte((byte)-48, (byte)n);
            }
        } else if (n < 128) {
            this.writeByte((byte)n);
        } else if (n < 256) {
            this.writeByteAndByte((byte)-52, (byte)n);
        } else if (n < 65536) {
            this.writeByteAndShort((byte)-51, (short)n);
        } else {
            this.writeByteAndInt((byte)-50, n);
        }
        return this;
    }

    public MessagePacker packLong(long l) throws IOException {
        if (l < -32L) {
            if (l < -32768L) {
                if (l < Integer.MIN_VALUE) {
                    this.writeByteAndLong((byte)-45, l);
                } else {
                    this.writeByteAndInt((byte)-46, (int)l);
                }
            } else if (l < -128L) {
                this.writeByteAndShort((byte)-47, (short)l);
            } else {
                this.writeByteAndByte((byte)-48, (byte)l);
            }
        } else if (l < 128L) {
            this.writeByte((byte)l);
        } else if (l < 65536L) {
            if (l < 256L) {
                this.writeByteAndByte((byte)-52, (byte)l);
            } else {
                this.writeByteAndShort((byte)-51, (short)l);
            }
        } else if (l < 0x100000000L) {
            this.writeByteAndInt((byte)-50, (int)l);
        } else {
            this.writeByteAndLong((byte)-49, l);
        }
        return this;
    }

    public MessagePacker packBigInteger(BigInteger bigInteger) throws IOException {
        if (bigInteger.bitLength() <= 63) {
            this.packLong(bigInteger.longValue());
        } else if (bigInteger.bitLength() == 64 && bigInteger.signum() == 1) {
            this.writeByteAndLong((byte)-49, bigInteger.longValue());
        } else {
            throw new IllegalArgumentException("Messagepack cannot serialize BigInteger larger than 2^64-1");
        }
        return this;
    }

    public MessagePacker packFloat(float f) throws IOException {
        this.writeByteAndFloat((byte)-54, f);
        return this;
    }

    public MessagePacker packDouble(double d) throws IOException {
        this.writeByteAndDouble((byte)-53, d);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessagePacker packString(String string) throws IOException {
        if (string.length() <= 0) {
            this.packRawStringHeader(0);
            return this;
        }
        CharBuffer charBuffer = CharBuffer.wrap(string);
        this.prepareEncoder();
        ByteBuffer byteBuffer = this.encodeBuffer;
        this.encodeBuffer.clear();
        this.encoder.reset();
        try {
            while (charBuffer.hasRemaining()) {
                try {
                    CoderResult coderResult = this.encoder.encode(charBuffer, this.encodeBuffer, true);
                    if (coderResult.isUnderflow()) {
                        coderResult = this.encoder.flush(this.encodeBuffer);
                    }
                    if (coderResult.isOverflow()) {
                        int n = Math.max(1, (int)((float)charBuffer.remaining() * this.encoder.averageBytesPerChar()));
                        this.encodeBuffer.flip();
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(Math.max((int)((double)this.encodeBuffer.capacity() * 1.5), this.encodeBuffer.remaining() + n));
                        byteBuffer2.put(this.encodeBuffer);
                        this.encodeBuffer = byteBuffer2;
                        this.encoder.reset();
                        continue;
                    }
                    if (!coderResult.isError() || (!coderResult.isMalformed() || this.config.getActionOnMalFormedInput() != CodingErrorAction.REPORT) && (!coderResult.isUnmappable() || this.config.getActionOnUnmappableCharacter() != CodingErrorAction.REPORT)) continue;
                    coderResult.throwException();
                }
                catch (CharacterCodingException characterCodingException) {
                    throw new MessageStringCodingException(characterCodingException);
                }
            }
            this.encodeBuffer.flip();
            this.packRawStringHeader(this.encodeBuffer.remaining());
            this.writePayload(this.encodeBuffer);
            return this;
        }
        finally {
            this.encodeBuffer = byteBuffer;
        }
    }

    public MessagePacker packArrayHeader(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (n < 16) {
            this.writeByte((byte)(0xFFFFFF90 | n));
        } else if (n < 65536) {
            this.writeByteAndShort((byte)-36, (short)n);
        } else {
            this.writeByteAndInt((byte)-35, n);
        }
        return this;
    }

    public MessagePacker packMapHeader(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (n < 16) {
            this.writeByte((byte)(0xFFFFFF80 | n));
        } else if (n < 65536) {
            this.writeByteAndShort((byte)-34, (short)n);
        } else {
            this.writeByteAndInt((byte)-33, n);
        }
        return this;
    }

    public MessagePacker pack(Value value) throws IOException {
        value.writeTo(this);
        return this;
    }

    public MessagePacker packExtendedType(int n, byte[] byArray, int n2, int n3) throws IOException {
        return this.packExtendedTypeHeader(n, n3).writePayload(byArray, n2, n3);
    }

    public MessagePacker packExtendedType(int n, byte[] byArray) throws IOException {
        return this.packExtendedType(n, byArray, 0, byArray.length);
    }

    public MessagePacker packExtendedType(int n, ByteBuffer byteBuffer) throws IOException {
        return this.packExtendedTypeHeader(n, byteBuffer.remaining()).writePayload(byteBuffer);
    }

    public MessagePacker packExtendedTypeHeader(int n, int n2) throws IOException {
        if (n2 < 256) {
            if (n2 > 0 && (n2 & n2 - 1) == 0) {
                if (n2 == 1) {
                    this.writeByteAndByte((byte)-44, (byte)n);
                } else if (n2 == 2) {
                    this.writeByteAndByte((byte)-43, (byte)n);
                } else if (n2 == 4) {
                    this.writeByteAndByte((byte)-42, (byte)n);
                } else if (n2 == 8) {
                    this.writeByteAndByte((byte)-41, (byte)n);
                } else {
                    this.writeByteAndByte((byte)-40, (byte)n);
                }
            } else {
                this.writeByteAndByte((byte)-57, (byte)n2);
                this.writeByte((byte)n);
            }
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-56, (short)n2);
            this.writeByte((byte)n);
        } else {
            this.writeByteAndInt((byte)-55, n2);
            this.writeByte((byte)n);
        }
        return this;
    }

    public MessagePacker packBinary(byte[] byArray) throws IOException {
        return this.packBinary(byArray, 0, byArray.length);
    }

    public MessagePacker packBinary(byte[] byArray, int n, int n2) throws IOException {
        return this.packBinaryHeader(n2).writePayload(byArray, n, n2);
    }

    public MessagePacker packBinary(ByteBuffer byteBuffer) throws IOException {
        return this.packBinaryHeader(byteBuffer.remaining()).writePayload(byteBuffer);
    }

    public MessagePacker packBinaryHeader(int n) throws IOException {
        if (n < 256) {
            this.writeByteAndByte((byte)-60, (byte)n);
        } else if (n < 65536) {
            this.writeByteAndShort((byte)-59, (short)n);
        } else {
            this.writeByteAndInt((byte)-58, n);
        }
        return this;
    }

    public MessagePacker packRawString(ByteBuffer byteBuffer) throws IOException {
        return this.packRawStringHeader(byteBuffer.remaining()).writePayload(byteBuffer);
    }

    public MessagePacker packRawStringHeader(int n) throws IOException {
        if (n < 32) {
            this.writeByte((byte)(0xFFFFFFA0 | n));
        } else if (n < 256) {
            this.writeByteAndByte((byte)-39, (byte)n);
        } else if (n < 65536) {
            this.writeByteAndShort((byte)-38, (short)n);
        } else {
            this.writeByteAndInt((byte)-37, n);
        }
        return this;
    }

    public MessagePacker writePayload(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() >= this.config.getPackerRawDataCopyingThreshold()) {
            this.flush();
            MessageBuffer messageBuffer = MessageBuffer.wrap(byteBuffer).slice(byteBuffer.position(), byteBuffer.remaining());
            this.flushBuffer(messageBuffer);
            byteBuffer.position(byteBuffer.limit());
        } else {
            while (byteBuffer.remaining() > 0) {
                if (this.position >= this.buffer.size()) {
                    this.flush();
                }
                int n = Math.min(this.buffer.size() - this.position, byteBuffer.remaining());
                this.buffer.putByteBuffer(this.position, byteBuffer, n);
                this.position += n;
            }
        }
        return this;
    }

    public MessagePacker writePayload(byte[] byArray) throws IOException {
        return this.writePayload(byArray, 0, byArray.length);
    }

    public MessagePacker writePayload(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.config.getPackerRawDataCopyingThreshold()) {
            this.flush();
            MessageBuffer messageBuffer = MessageBuffer.wrap(byArray).slice(n, n2);
            this.flushBuffer(messageBuffer);
        } else {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                if (this.position >= this.buffer.size()) {
                    this.flush();
                }
                n3 = Math.min(this.buffer.size() - this.position, n2 - i);
                this.buffer.putBytes(this.position, byArray, n + i, n3);
                this.position += n3;
            }
        }
        return this;
    }
}

