/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.msgpack.core.Preconditions;

public class MessagePack {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    static final Config DEFAULT_CONFIG = new ConfigBuilder().build();

    public static final class Code {
        public static final byte POSFIXINT_MASK = -128;
        public static final byte FIXMAP_PREFIX = -128;
        public static final byte FIXARRAY_PREFIX = -112;
        public static final byte FIXSTR_PREFIX = -96;
        public static final byte NIL = -64;
        public static final byte NEVER_USED = -63;
        public static final byte FALSE = -62;
        public static final byte TRUE = -61;
        public static final byte BIN8 = -60;
        public static final byte BIN16 = -59;
        public static final byte BIN32 = -58;
        public static final byte EXT8 = -57;
        public static final byte EXT16 = -56;
        public static final byte EXT32 = -55;
        public static final byte FLOAT32 = -54;
        public static final byte FLOAT64 = -53;
        public static final byte UINT8 = -52;
        public static final byte UINT16 = -51;
        public static final byte UINT32 = -50;
        public static final byte UINT64 = -49;
        public static final byte INT8 = -48;
        public static final byte INT16 = -47;
        public static final byte INT32 = -46;
        public static final byte INT64 = -45;
        public static final byte FIXEXT1 = -44;
        public static final byte FIXEXT2 = -43;
        public static final byte FIXEXT4 = -42;
        public static final byte FIXEXT8 = -41;
        public static final byte FIXEXT16 = -40;
        public static final byte STR8 = -39;
        public static final byte STR16 = -38;
        public static final byte STR32 = -37;
        public static final byte ARRAY16 = -36;
        public static final byte ARRAY32 = -35;
        public static final byte MAP16 = -34;
        public static final byte MAP32 = -33;
        public static final byte NEGFIXINT_PREFIX = -32;

        public static final boolean isFixInt(byte by) {
            int n = by & 0xFF;
            return n <= 127 || n >= 224;
        }

        public static final boolean isPosFixInt(byte by) {
            return (by & 0xFFFFFF80) == 0;
        }

        public static final boolean isNegFixInt(byte by) {
            return (by & 0xFFFFFFE0) == -32;
        }

        public static final boolean isFixStr(byte by) {
            return (by & 0xFFFFFFE0) == -96;
        }

        public static final boolean isFixedArray(byte by) {
            return (by & 0xFFFFFFF0) == -112;
        }

        public static final boolean isFixedMap(byte by) {
            return (by & 0xFFFFFFE0) == -128;
        }

        public static final boolean isFixedRaw(byte by) {
            return (by & 0xFFFFFFE0) == -96;
        }
    }

    public static class ConfigBuilder {
        private boolean readStringAsBinary = true;
        private boolean readBinaryAsString = true;
        private CodingErrorAction onMalFormedInput = CodingErrorAction.REPORT;
        private CodingErrorAction onUnmappableCharacter = CodingErrorAction.REPORT;
        private int maxUnpackStringSize = Integer.MAX_VALUE;
        private int stringEncoderBufferSize = 8192;
        private int stringDecoderBufferSize = 8192;
        private int packerBufferSize = 8192;
        private int packerRawDataCopyingThreshold = 512;

        public Config build() {
            return new Config(this.readStringAsBinary, this.readBinaryAsString, this.onMalFormedInput, this.onUnmappableCharacter, this.maxUnpackStringSize, this.stringEncoderBufferSize, this.stringDecoderBufferSize, this.packerBufferSize, this.packerRawDataCopyingThreshold);
        }

        public ConfigBuilder readStringAsBinary(boolean bl) {
            this.readStringAsBinary = bl;
            return this;
        }

        public ConfigBuilder readBinaryAsString(boolean bl) {
            this.readBinaryAsString = bl;
            return this;
        }

        public ConfigBuilder onMalFormedInput(CodingErrorAction codingErrorAction) {
            this.onMalFormedInput = codingErrorAction;
            return this;
        }

        public ConfigBuilder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
            this.onUnmappableCharacter = codingErrorAction;
            return this;
        }

        public ConfigBuilder maxUnpackStringSize(int n) {
            this.maxUnpackStringSize = n;
            return this;
        }

        public ConfigBuilder stringEncoderBufferSize(int n) {
            this.stringEncoderBufferSize = n;
            return this;
        }

        public ConfigBuilder stringDecoderBufferSize(int n) {
            this.stringDecoderBufferSize = n;
            return this;
        }

        public ConfigBuilder packerBufferSize(int n) {
            this.packerBufferSize = n;
            return this;
        }

        public ConfigBuilder packerRawDataCopyingThreshold(int n) {
            this.packerRawDataCopyingThreshold = n;
            return this;
        }
    }

    public static class Config {
        private final boolean readStringAsBinary;
        private final boolean readBinaryAsString;
        private final CodingErrorAction onMalFormedInput;
        private final CodingErrorAction onUnmappableCharacter;
        private final int maxUnpackStringSize;
        private final int stringEncoderBufferSize;
        private final int stringDecoderBufferSize;
        private final int packerBufferSize;
        private final int packerRawDataCopyingThreshold;

        public Config(boolean bl, boolean bl2, CodingErrorAction codingErrorAction, CodingErrorAction codingErrorAction2, int n, int n2, int n3, int n4, int n5) {
            Preconditions.checkArgument(n4 > 0, "packer buffer size must be larger than 0: " + n4);
            Preconditions.checkArgument(n2 > 0, "string encoder buffer size must be larger than 0: " + n2);
            Preconditions.checkArgument(n3 > 0, "string decoder buffer size must be larger than 0: " + n3);
            this.readStringAsBinary = bl;
            this.readBinaryAsString = bl2;
            this.onMalFormedInput = codingErrorAction;
            this.onUnmappableCharacter = codingErrorAction2;
            this.maxUnpackStringSize = n;
            this.stringEncoderBufferSize = n2;
            this.stringDecoderBufferSize = n3;
            this.packerBufferSize = n4;
            this.packerRawDataCopyingThreshold = n5;
        }

        public boolean isReadStringAsBinary() {
            return this.readStringAsBinary;
        }

        public boolean isReadBinaryAsString() {
            return this.readBinaryAsString;
        }

        public CodingErrorAction getActionOnMalFormedInput() {
            return this.onMalFormedInput;
        }

        public CodingErrorAction getActionOnUnmappableCharacter() {
            return this.onUnmappableCharacter;
        }

        public int getMaxUnpackStringSize() {
            return this.maxUnpackStringSize;
        }

        public int getStringEncoderBufferSize() {
            return this.stringEncoderBufferSize;
        }

        public int getStringDecoderBufferSize() {
            return this.stringDecoderBufferSize;
        }

        public int getPackerBufferSize() {
            return this.packerBufferSize;
        }

        public int getPackerRawDataCopyingThreshold() {
            return this.packerRawDataCopyingThreshold;
        }
    }
}

