/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.mp4parser.streaming.extensions.TrackIdTrackExtension;
import org.mp4parser.streaming.input.h264.H264NalConsumingTrack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264AnnexBTrack
extends H264NalConsumingTrack
implements Callable<Void> {
    private InputStream inputStream;

    public H264AnnexBTrack(InputStream inputStream) throws IOException {
        assert (inputStream != null);
        this.inputStream = new BufferedInputStream(inputStream);
    }

    @Override
    public Void call() throws IOException, InterruptedException {
        byte[] nal;
        NalStreamTokenizer st = new NalStreamTokenizer(this.inputStream);
        while ((nal = st.getNext()) != null) {
            this.consumeNal(ByteBuffer.wrap(nal));
        }
        this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), true, true);
        return null;
    }

    public String toString() {
        TrackIdTrackExtension trackIdTrackExtension = this.getTrackExtension(TrackIdTrackExtension.class);
        if (trackIdTrackExtension != null) {
            return "H264AnnexBTrack{trackId=" + trackIdTrackExtension.getTrackId() + "}";
        }
        return "H264AnnexBTrack{}";
    }

    static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream() {
        }

        public byte[] toByteArrayLess3() {
            if (this.count > 3) {
                return Arrays.copyOf(this.buf, this.count - 3 > 0 ? this.count - 3 : 0);
            }
            return null;
        }
    }

    public static class NalStreamTokenizer {
        private static Logger LOG = LoggerFactory.getLogger((String)NalStreamTokenizer.class.getName());
        MyByteArrayOutputStream next = new MyByteArrayOutputStream();
        int pattern = 0;
        private InputStream inputStream;

        public NalStreamTokenizer(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public byte[] getNext() throws IOException {
            byte[] s;
            int c;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNext() called");
            }
            while ((c = this.inputStream.read()) != -1) {
                if (this.pattern != 2 || c != 3) {
                    this.next.write(c);
                    if (this.pattern == 0 && c == 0) {
                        this.pattern = 1;
                        continue;
                    }
                    if (this.pattern == 1 && c == 0) {
                        this.pattern = 2;
                        continue;
                    }
                    if (this.pattern == 2 && c == 0) {
                        s = this.next.toByteArrayLess3();
                        this.next.reset();
                        if (s == null) continue;
                        return s;
                    }
                    if (this.pattern == 2 && c == 1) {
                        s = this.next.toByteArrayLess3();
                        this.next.reset();
                        this.pattern = 0;
                        if (s == null) continue;
                        return s;
                    }
                    if (this.pattern == 0) continue;
                    this.pattern = 0;
                    continue;
                }
                this.pattern = 0;
            }
            s = this.next.toByteArray();
            this.next.reset();
            if (s.length > 0) {
                return s;
            }
            return null;
        }
    }
}

