/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.aac;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.AudioSpecificConfig;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.SLConfigDescriptor;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.streaming.extensions.DefaultSampleFlagsTrackExtension;
import org.mp4parser.streaming.extensions.TrackIdTrackExtension;
import org.mp4parser.streaming.input.AbstractStreamingTrack;
import org.mp4parser.streaming.input.StreamingSampleImpl;
import org.mp4parser.streaming.input.aac.AdtsHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdtsAacStreamingTrack
extends AbstractStreamingTrack
implements Callable<Void> {
    private static Map<Integer, Integer> samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
    private static Logger LOG = LoggerFactory.getLogger((String)AdtsAacStreamingTrack.class.getName());
    CountDownLatch gotFirstSample = new CountDownLatch(1);
    SampleDescriptionBox stsd = null;
    private InputStream is;
    private boolean closed;
    private AdtsHeader firstHeader;
    private String lang = "und";
    private long avgBitrate;
    private long maxBitrate;

    public AdtsAacStreamingTrack(InputStream is, long avgBitrate, long maxBitrate) {
        this.avgBitrate = avgBitrate;
        this.maxBitrate = maxBitrate;
        assert (is != null);
        this.is = is;
        DefaultSampleFlagsTrackExtension defaultSampleFlagsTrackExtension = new DefaultSampleFlagsTrackExtension();
        defaultSampleFlagsTrackExtension.setIsLeading(2);
        defaultSampleFlagsTrackExtension.setSampleDependsOn(2);
        defaultSampleFlagsTrackExtension.setSampleIsDependedOn(2);
        defaultSampleFlagsTrackExtension.setSampleHasRedundancy(2);
        defaultSampleFlagsTrackExtension.setSampleIsNonSyncSample(false);
        this.addTrackExtension(defaultSampleFlagsTrackExtension);
    }

    private static AdtsHeader readADTSHeader(InputStream fis) throws IOException {
        AdtsHeader hdr = new AdtsHeader();
        int x = fis.read();
        int syncword = x << 4;
        x = fis.read();
        if (x == -1) {
            return null;
        }
        if ((syncword += x >> 4) != 4095) {
            throw new IOException("Expected Start Word 0xfff");
        }
        hdr.mpegVersion = (x & 8) >> 3;
        hdr.layer = (x & 6) >> 1;
        hdr.protectionAbsent = x & 1;
        x = fis.read();
        hdr.profile = ((x & 0xC0) >> 6) + 1;
        hdr.sampleFrequencyIndex = (x & 0x3C) >> 2;
        assert (hdr.sampleFrequencyIndex != 15);
        hdr.sampleRate = samplingFrequencyIndexMap.get(hdr.sampleFrequencyIndex);
        hdr.channelconfig = (x & 1) << 2;
        x = fis.read();
        hdr.channelconfig += (x & 0xC0) >> 6;
        hdr.original = (x & 0x20) >> 5;
        hdr.home = (x & 0x10) >> 4;
        hdr.copyrightedStream = (x & 8) >> 3;
        hdr.copyrightStart = (x & 4) >> 2;
        hdr.frameLength = (x & 3) << 9;
        x = fis.read();
        hdr.frameLength += x << 3;
        x = fis.read();
        hdr.frameLength += (x & 0xE0) >> 5;
        hdr.bufferFullness = (x & 0x1F) << 6;
        x = fis.read();
        hdr.bufferFullness += (x & 0xFC) >> 2;
        hdr.numAacFramesPerAdtsFrame = (x & 3) + 1;
        if (hdr.numAacFramesPerAdtsFrame != 1) {
            throw new IOException("This muxer can only work with 1 AAC frame per ADTS frame");
        }
        if (hdr.protectionAbsent == 0) {
            int crc1 = fis.read();
            int n = fis.read();
        }
        return hdr;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized SampleDescriptionBox getSampleDescriptionBox() {
        this.waitForFirstSample();
        if (this.stsd == null) {
            this.stsd = new SampleDescriptionBox();
            AudioSampleEntry audioSampleEntry = new AudioSampleEntry("mp4a");
            if (this.firstHeader.channelconfig == 7) {
                audioSampleEntry.setChannelCount(8);
            } else {
                audioSampleEntry.setChannelCount(this.firstHeader.channelconfig);
            }
            audioSampleEntry.setSampleRate((long)this.firstHeader.sampleRate);
            audioSampleEntry.setDataReferenceIndex(1);
            audioSampleEntry.setSampleSize(16);
            ESDescriptorBox esds = new ESDescriptorBox();
            ESDescriptor descriptor = new ESDescriptor();
            descriptor.setEsId(0);
            SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
            slConfigDescriptor.setPredefined(2);
            descriptor.setSlConfigDescriptor(slConfigDescriptor);
            DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
            decoderConfigDescriptor.setObjectTypeIndication(64);
            decoderConfigDescriptor.setStreamType(5);
            decoderConfigDescriptor.setBufferSizeDB(1536);
            decoderConfigDescriptor.setMaxBitRate(this.maxBitrate);
            decoderConfigDescriptor.setAvgBitRate(this.avgBitrate);
            AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
            audioSpecificConfig.setOriginalAudioObjectType(2);
            audioSpecificConfig.setSamplingFrequencyIndex(this.firstHeader.sampleFrequencyIndex);
            audioSpecificConfig.setChannelConfiguration(this.firstHeader.channelconfig);
            decoderConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
            descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
            esds.setEsDescriptor(descriptor);
            audioSampleEntry.addBox((Box)esds);
            this.stsd.addBox((Box)audioSampleEntry);
        }
        return this.stsd;
    }

    void waitForFirstSample() {
        try {
            this.gotFirstSample.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getTimescale() {
        this.waitForFirstSample();
        return this.firstHeader.sampleRate;
    }

    @Override
    public String getHandler() {
        return "soun";
    }

    @Override
    public String getLanguage() {
        return this.lang;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.is.close();
    }

    @Override
    public Void call() throws Exception {
        boolean i = true;
        try {
            AdtsHeader header;
            while ((header = AdtsAacStreamingTrack.readADTSHeader(this.is)) != null) {
                int count;
                if (this.firstHeader == null) {
                    this.firstHeader = header;
                    this.gotFirstSample.countDown();
                }
                byte[] frame = new byte[header.frameLength - header.getSize()];
                for (int n = 0; n < frame.length; n += count) {
                    count = this.is.read(frame, n, frame.length - n);
                    if (count >= 0) continue;
                    throw new EOFException();
                }
                this.sampleSink.acceptSample(new StreamingSampleImpl(ByteBuffer.wrap(frame), 1024L), this);
            }
        }
        catch (EOFException e) {
            LOG.info("Done reading ADTS AAC file.");
        }
        return null;
    }

    public String toString() {
        TrackIdTrackExtension trackIdTrackExtension = this.getTrackExtension(TrackIdTrackExtension.class);
        if (trackIdTrackExtension != null) {
            return "AdtsAacStreamingTrack{trackId=" + trackIdTrackExtension.getTrackId() + "}";
        }
        return "AdtsAacStreamingTrack{}";
    }

    static {
        samplingFrequencyIndexMap.put(96000, 0);
        samplingFrequencyIndexMap.put(88200, 1);
        samplingFrequencyIndexMap.put(64000, 2);
        samplingFrequencyIndexMap.put(48000, 3);
        samplingFrequencyIndexMap.put(44100, 4);
        samplingFrequencyIndexMap.put(32000, 5);
        samplingFrequencyIndexMap.put(24000, 6);
        samplingFrequencyIndexMap.put(22050, 7);
        samplingFrequencyIndexMap.put(16000, 8);
        samplingFrequencyIndexMap.put(12000, 9);
        samplingFrequencyIndexMap.put(11025, 10);
        samplingFrequencyIndexMap.put(8000, 11);
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
    }
}

