/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.mp4;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.mp4parser.BasicContainer;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;
import org.mp4parser.PropertyBoxParserImpl;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.DegradationPriorityBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.streaming.StreamingTrack;
import org.mp4parser.streaming.TrackExtension;
import org.mp4parser.streaming.extensions.CompositionTimeSampleExtension;
import org.mp4parser.streaming.extensions.CompositionTimeTrackExtension;
import org.mp4parser.streaming.extensions.SampleFlagsSampleExtension;
import org.mp4parser.streaming.extensions.TrackIdTrackExtension;
import org.mp4parser.streaming.input.StreamingSampleImpl;
import org.mp4parser.streaming.input.mp4.DiscardingByteArrayOutputStream;
import org.mp4parser.streaming.output.SampleSink;
import org.mp4parser.streaming.output.mp4.FragmentedMp4Writer;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Path;

public class ClassicMp4ContainerSource
implements Callable<Void> {
    final HashMap<TrackBox, Mp4StreamingTrack> tracks = new LinkedHashMap<TrackBox, Mp4StreamingTrack>();
    final HashMap<TrackBox, Long> currentChunks = new HashMap();
    final HashMap<TrackBox, Long> currentSamples = new HashMap();
    final DiscardingByteArrayOutputStream baos = new DiscardingByteArrayOutputStream();
    final ReadableByteChannel readableByteChannel;
    private final ByteBuffer BUFFER = ByteBuffer.allocateDirect(65535);

    public ClassicMp4ContainerSource(InputStream is) throws IOException {
        this.readableByteChannel = Channels.newChannel(new TeeInputStream(is, this.baos));
        BasicContainer container = new BasicContainer();
        PropertyBoxParserImpl boxParser = new PropertyBoxParserImpl(new String[0]);
        ParsableBox current = null;
        while (current == null || !"moov".equals(current.getType())) {
            current = boxParser.parseBox(this.readableByteChannel, null);
            container.addBox((Box)current);
        }
        for (TrackBox trackBox : Path.getPaths((Container)container, (String)"moov[0]/trak")) {
            Mp4StreamingTrack mp4StreamingTrack = new Mp4StreamingTrack(trackBox);
            this.tracks.put(trackBox, mp4StreamingTrack);
            if (trackBox.getSampleTableBox().getCompositionTimeToSample() != null) {
                mp4StreamingTrack.addTrackExtension(new CompositionTimeTrackExtension());
            }
            mp4StreamingTrack.addTrackExtension(new TrackIdTrackExtension(trackBox.getTrackHeaderBox().getTrackId()));
            this.currentChunks.put(trackBox, 1L);
            this.currentSamples.put(trackBox, 1L);
        }
    }

    public static void main(String[] args) throws IOException {
        ClassicMp4ContainerSource classicMp4ContainerSource = null;
        try {
            classicMp4ContainerSource = new ClassicMp4ContainerSource(new URI("http://org.mp4parser.s3.amazonaws.com/examples/Cosmos%20Laundromat%20small%20faststart.mp4").toURL().openStream());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        List<StreamingTrack> streamingTracks = classicMp4ContainerSource.getTracks();
        File f = new File("output.mp4");
        FragmentedMp4Writer writer = new FragmentedMp4Writer(streamingTracks, new FileOutputStream(f).getChannel());
        System.out.println("Reading and writing started.");
        classicMp4ContainerSource.call();
        writer.close();
        System.err.println(f.getAbsolutePath());
    }

    List<StreamingTrack> getTracks() {
        return new ArrayList<StreamingTrack>(this.tracks.values());
    }

    @Override
    public Void call() throws IOException {
        while (true) {
            SampleToChunkBox.Entry _entry;
            TrackBox firstInLine = null;
            long currentChunk = 0L;
            long currentChunkStartSample = 0L;
            long offset = Long.MAX_VALUE;
            SampleToChunkBox.Entry entry = null;
            for (TrackBox trackBox : this.tracks.keySet()) {
                long _currentChunk = this.currentChunks.get(trackBox);
                long _currentSample = this.currentSamples.get(trackBox);
                long[] chunkOffsets = trackBox.getSampleTableBox().getChunkOffsetBox().getChunkOffsets();
                if (CastUtils.l2i((long)_currentChunk) - 1 >= chunkOffsets.length || chunkOffsets[CastUtils.l2i((long)_currentChunk) - 1] >= offset) continue;
                firstInLine = trackBox;
                currentChunk = _currentChunk;
                currentChunkStartSample = _currentSample;
                offset = chunkOffsets[CastUtils.l2i((long)_currentChunk) - 1];
            }
            if (firstInLine == null) break;
            SampleToChunkBox stsc = firstInLine.getSampleTableBox().getSampleToChunkBox();
            Iterator iterator = stsc.getEntries().iterator();
            while (iterator.hasNext() && currentChunk >= (_entry = (SampleToChunkBox.Entry)iterator.next()).getFirstChunk()) {
                entry = _entry;
            }
            assert (entry != null);
            SampleTableBox sampleTableBox = firstInLine.getSampleTableBox();
            List times = sampleTableBox.getTimeToSampleBox().getEntries();
            List compositionOffsets = sampleTableBox.getCompositionTimeToSample() != null ? sampleTableBox.getCompositionTimeToSample().getEntries() : null;
            SampleSizeBox stsz = sampleTableBox.getSampleSizeBox();
            for (long index = currentChunkStartSample; index < currentChunkStartSample + entry.getSamplesPerChunk(); ++index) {
                DegradationPriorityBox stdp;
                long duration = ((TimeToSampleBox.Entry)times.get(0)).getDelta();
                if (((TimeToSampleBox.Entry)times.get(0)).getCount() == 1L) {
                    times.remove(0);
                } else {
                    ((TimeToSampleBox.Entry)times.get(0)).setCount(((TimeToSampleBox.Entry)times.get(0)).getCount() - 1L);
                }
                SampleDependencyTypeBox sdtp = (SampleDependencyTypeBox)Path.getPath((AbstractContainerBox)sampleTableBox, (String)"sdtp");
                SampleFlagsSampleExtension sfse = new SampleFlagsSampleExtension();
                if (sdtp != null) {
                    SampleDependencyTypeBox.Entry e = (SampleDependencyTypeBox.Entry)sdtp.getEntries().get(CastUtils.l2i((long)index));
                    sfse.setIsLeading(e.getIsLeading());
                    sfse.setSampleDependsOn(e.getSampleDependsOn());
                    sfse.setSampleIsDependedOn(e.getSampleIsDependedOn());
                    sfse.setSampleHasRedundancy(e.getSampleHasRedundancy());
                }
                if (sampleTableBox.getSyncSampleBox() != null) {
                    if (Arrays.binarySearch(sampleTableBox.getSyncSampleBox().getSampleNumber(), index) >= 0) {
                        sfse.setSampleIsNonSyncSample(false);
                    } else {
                        sfse.setSampleIsNonSyncSample(true);
                    }
                }
                if ((stdp = (DegradationPriorityBox)Path.getPath((AbstractContainerBox)sampleTableBox, (String)"stdp")) != null) {
                    sfse.setSampleDegradationPriority(stdp.getPriorities()[CastUtils.l2i((long)index)]);
                }
                int sampleSize = CastUtils.l2i((long)stsz.getSampleSizeAtIndex(CastUtils.l2i((long)(index - 1L))));
                long avail = this.baos.available();
                while (avail <= offset + (long)sampleSize) {
                    try {
                        int br = this.readableByteChannel.read(this.BUFFER);
                        if (br == -1) break;
                        avail = this.baos.available();
                        this.BUFFER.rewind();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                byte[] sampleContent = this.baos.get(offset, sampleSize);
                StreamingSampleImpl streamingSample = new StreamingSampleImpl(sampleContent, duration);
                streamingSample.addSampleExtension(sfse);
                if (compositionOffsets != null && !compositionOffsets.isEmpty()) {
                    long compositionOffset = ((CompositionTimeToSample.Entry)compositionOffsets.get(0)).getOffset();
                    if (((CompositionTimeToSample.Entry)compositionOffsets.get(0)).getCount() == 1) {
                        compositionOffsets.remove(0);
                    } else {
                        ((CompositionTimeToSample.Entry)compositionOffsets.get(0)).setCount(((CompositionTimeToSample.Entry)compositionOffsets.get(0)).getCount() - 1);
                    }
                    streamingSample.addSampleExtension(CompositionTimeSampleExtension.create(compositionOffset));
                }
                if (firstInLine.getTrackHeaderBox().getTrackId() == 1L) {
                    System.out.println("Pushing sample @" + offset + " of " + sampleSize + " bytes (i=" + index + ")");
                }
                this.tracks.get(firstInLine).getSampleSink().acceptSample(streamingSample, this.tracks.get(firstInLine));
                offset += (long)sampleSize;
            }
            this.baos.discardTo(offset);
            this.currentChunks.put(firstInLine, currentChunk + 1L);
            this.currentSamples.put(firstInLine, currentChunkStartSample + entry.getSamplesPerChunk());
        }
        for (Mp4StreamingTrack mp4StreamingTrack : this.tracks.values()) {
            mp4StreamingTrack.close();
        }
        System.out.println("All Samples read.");
        return null;
    }

    public static class TeeInputStream
    extends FilterInputStream {
        private final OutputStream branch;
        long counter = 0L;

        public TeeInputStream(InputStream input, OutputStream branch) {
            super(input);
            this.branch = branch;
        }

        @Override
        public int read() throws IOException {
            int ch = super.read();
            if (ch != -1) {
                this.branch.write(ch);
                ++this.counter;
            }
            return ch;
        }

        @Override
        public int read(byte[] bts, int st, int end) throws IOException {
            int n = super.read(bts, st, end);
            if (n != -1) {
                this.branch.write(bts, st, n);
                this.counter += (long)n;
            }
            return n;
        }

        @Override
        public int read(byte[] bts) throws IOException {
            int n = super.read(bts);
            if (n != -1) {
                this.branch.write(bts, 0, n);
                this.counter += (long)n;
            }
            return n;
        }
    }

    public static class Mp4StreamingTrack
    implements StreamingTrack {
        private final TrackBox trackBox;
        protected HashMap<Class<? extends TrackExtension>, TrackExtension> trackExtensions = new HashMap();
        boolean allSamplesRead = false;
        SampleSink sampleSink;

        public Mp4StreamingTrack(TrackBox trackBox) {
            this.trackBox = trackBox;
        }

        @Override
        public void close() {
            this.allSamplesRead = true;
        }

        public boolean isClosed() {
            return this.allSamplesRead;
        }

        @Override
        public long getTimescale() {
            return this.trackBox.getMediaBox().getMediaHeaderBox().getTimescale();
        }

        public SampleSink getSampleSink() {
            return this.sampleSink;
        }

        @Override
        public void setSampleSink(SampleSink sampleSink) {
            this.sampleSink = sampleSink;
        }

        @Override
        public String getHandler() {
            return this.trackBox.getMediaBox().getHandlerBox().getHandlerType();
        }

        @Override
        public String getLanguage() {
            return this.trackBox.getMediaBox().getMediaHeaderBox().getLanguage();
        }

        @Override
        public SampleDescriptionBox getSampleDescriptionBox() {
            return this.trackBox.getSampleTableBox().getSampleDescriptionBox();
        }

        @Override
        public <T extends TrackExtension> T getTrackExtension(Class<T> clazz) {
            return (T)this.trackExtensions.get(clazz);
        }

        @Override
        public void addTrackExtension(TrackExtension trackExtension) {
            this.trackExtensions.put(trackExtension.getClass(), trackExtension);
        }

        @Override
        public void removeTrackExtension(Class<? extends TrackExtension> clazz) {
            this.trackExtensions.remove(clazz);
        }
    }
}

