/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
Extracted from commons-codec
 */
package org.mp4parser.tools;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

/**
 * Converts hexadecimal Strings.
 */
public class Hex {
    private static final char[] DIGITS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeHex(byte[] data) {
        return encodeHex(data, 0);
    }

    public static String encodeHex(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate();
        StringBuilder sb = new StringBuilder();
        while (byteBuffer.remaining() > 0) {
            byte b = byteBuffer.get();
            sb.append(DIGITS[(0xF0 & b) >>> 4]);
            sb.append(DIGITS[0x0F & b]);
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] data, int group) {
        int l = data.length;
        char[] out = new char[(l << 1) + (group > 0 ? (l / group) : 0)];
        // two characters form the hex value.
        for (int i = 0, j = 0; i < l; i++) {
            if ((group > 0) && ((i % group) == 0) && j > 0) {
                out[j++] = '-';
            }

            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0x0F & data[i]];
        }
        return new String(out);
    }


    public static byte[] decodeHex(String hexString) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        for (int i = 0; i < hexString.length(); i += 2) {
            int b = Integer.parseInt(hexString.substring(i, i + 2), 16);
            bas.write(b);
        }
        return bas.toByteArray();
    }
}
