/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.sampleentry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.mp4parser.BoxParser;
import org.mp4parser.Container;
import org.mp4parser.boxes.sampleentry.AbstractSampleEntry;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Utf8;

public final class VisualSampleEntry
extends AbstractSampleEntry
implements Container {
    public static final String TYPE1 = "mp4v";
    public static final String TYPE2 = "s263";
    public static final String TYPE3 = "avc1";
    public static final String TYPE4 = "avc3";
    public static final String TYPE5 = "drmi";
    public static final String TYPE6 = "hvc1";
    public static final String TYPE7 = "hev1";
    public static final String TYPE_ENCRYPTED = "encv";
    private int width;
    private int height;
    private double horizresolution = 72.0;
    private double vertresolution = 72.0;
    private int frameCount = 1;
    private String compressorname = "";
    private int depth = 24;
    private long[] predefined = new long[3];

    public VisualSampleEntry() {
        super(TYPE3);
    }

    public VisualSampleEntry(String type) {
        super(type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getHorizresolution() {
        return this.horizresolution;
    }

    public void setHorizresolution(double horizresolution) {
        this.horizresolution = horizresolution;
    }

    public double getVertresolution() {
        return this.vertresolution;
    }

    public void setVertresolution(double vertresolution) {
        this.vertresolution = vertresolution;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public String getCompressorname() {
        return this.compressorname;
    }

    public void setCompressorname(String compressorname) {
        this.compressorname = compressorname;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer content = ByteBuffer.allocate(78);
        dataSource.read(content);
        content.position(6);
        this.dataReferenceIndex = IsoTypeReader.readUInt16(content);
        long tmp = IsoTypeReader.readUInt16(content);
        assert (0L == tmp) : "reserved byte not 0";
        tmp = IsoTypeReader.readUInt16(content);
        assert (0L == tmp) : "reserved byte not 0";
        this.predefined[0] = IsoTypeReader.readUInt32(content);
        this.predefined[1] = IsoTypeReader.readUInt32(content);
        this.predefined[2] = IsoTypeReader.readUInt32(content);
        this.width = IsoTypeReader.readUInt16(content);
        this.height = IsoTypeReader.readUInt16(content);
        this.horizresolution = IsoTypeReader.readFixedPoint1616(content);
        this.vertresolution = IsoTypeReader.readFixedPoint1616(content);
        tmp = IsoTypeReader.readUInt32(content);
        assert (0L == tmp) : "reserved byte not 0";
        this.frameCount = IsoTypeReader.readUInt16(content);
        int compressornameDisplayAbleData = IsoTypeReader.readUInt8(content);
        if (compressornameDisplayAbleData > 31) {
            compressornameDisplayAbleData = 31;
        }
        byte[] bytes = new byte[compressornameDisplayAbleData];
        content.get(bytes);
        this.compressorname = Utf8.convert(bytes);
        if (compressornameDisplayAbleData < 31) {
            byte[] zeros = new byte[31 - compressornameDisplayAbleData];
            content.get(zeros);
        }
        this.depth = IsoTypeReader.readUInt16(content);
        tmp = IsoTypeReader.readUInt16(content);
        assert (65535L == tmp);
        this.initContainer(dataSource, contentSize - 78L, boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer byteBuffer = ByteBuffer.allocate(78);
        byteBuffer.position(6);
        IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt16(byteBuffer, 0);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[0]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[1]);
        IsoTypeWriter.writeUInt32(byteBuffer, this.predefined[2]);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getWidth());
        IsoTypeWriter.writeUInt16(byteBuffer, this.getHeight());
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.getHorizresolution());
        IsoTypeWriter.writeFixedPoint1616(byteBuffer, this.getVertresolution());
        IsoTypeWriter.writeUInt32(byteBuffer, 0L);
        IsoTypeWriter.writeUInt16(byteBuffer, this.getFrameCount());
        IsoTypeWriter.writeUInt8(byteBuffer, Utf8.utf8StringLengthInBytes(this.getCompressorname()));
        byteBuffer.put(Utf8.convert(this.getCompressorname()));
        int a = Utf8.utf8StringLengthInBytes(this.getCompressorname());
        while (a < 31) {
            ++a;
            byteBuffer.put((byte)0);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.getDepth());
        IsoTypeWriter.writeUInt16(byteBuffer, 65535);
        writableByteChannel.write(byteBuffer.rewind());
        this.writeContainer(writableByteChannel);
    }

    @Override
    public long getSize() {
        long s = this.getContainerSize();
        long t = 78L;
        return s + t + (long)(this.largeBox || s + t + 8L >= 0x100000000L ? 16 : 8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisualSampleEntry that = (VisualSampleEntry)o;
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try {
            this.getBox(Channels.newChannel(baos1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            that.getBox(Channels.newChannel(baos2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Arrays.equals(baos1.toByteArray(), baos2.toByteArray());
    }

    public int hashCode() {
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        try {
            this.getBox(Channels.newChannel(baos1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Arrays.hashCode(baos1.toByteArray());
    }
}

