/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.internal.Conversions;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.boxes.iso14496.part12.SampleFlags;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    public TrackRunBox() {
        super(TYPE);
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        List<Entry> list = entries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public long[] getSampleCompositionTimeOffsets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] result = new long[this.entries.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.entries.get(i).getSampleCompositionTimeOffset();
                ++i;
            }
            return result;
        }
        return null;
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            size += 4L;
        }
        if ((flags & 4) == 4) {
            size += 4L;
        }
        long entrySize = 0L;
        if ((flags & 0x100) == 256) {
            entrySize += 4L;
        }
        if ((flags & 0x200) == 512) {
            entrySize += 4L;
        }
        if ((flags & 0x400) == 1024) {
            entrySize += 4L;
        }
        if ((flags & 0x800) == 2048) {
            entrySize += 4L;
        }
        return size += entrySize * (long)this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        int flags = this.getFlags();
        if ((flags & 1) == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.dataOffset);
        }
        if ((flags & 4) == 4) {
            this.firstSampleFlags.getContent(byteBuffer);
        }
        for (Entry entry : this.entries) {
            if ((flags & 0x100) == 256) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleDuration);
            }
            if ((flags & 0x200) == 512) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleSize);
            }
            if ((flags & 0x400) == 1024) {
                entry.sampleFlags.getContent(byteBuffer);
            }
            if ((flags & 0x800) != 2048) continue;
            if (this.getVersion() == 0) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleCompositionTimeOffset);
                continue;
            }
            byteBuffer.putInt((int)entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        long sampleCount = IsoTypeReader.readUInt32(content);
        this.dataOffset = (this.getFlags() & 1) == 1 ? CastUtils.l2i(IsoTypeReader.readUInt32(content)) : -1;
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(content);
        }
        int i = 0;
        while ((long)i < sampleCount) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = IsoTypeReader.readUInt32(content);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(content);
            }
            if ((this.getFlags() & 0x800) == 2048) {
                entry.sampleCompositionTimeOffset = content.getInt();
            }
            this.entries.add(entry);
            ++i;
        }
    }

    public long getSampleCount() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 1) == 1;
    }

    public void setDataOffsetPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    public boolean isFirstSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 4) == 4;
    }

    public boolean isSampleSizePresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x200) == 512;
    }

    public void setSampleSizePresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x200);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFF);
        }
    }

    public boolean isSampleDurationPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x100) == 256;
    }

    public void setSampleDurationPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x100);
        } else {
            this.setFlags(this.getFlags() & 0xFFFEFF);
        }
    }

    public boolean isSampleFlagsPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x400) == 1024;
    }

    public void setSampleFlagsPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x400);
        } else {
            this.setFlags(this.getFlags() & 0xFFFBFF);
        }
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 0x800) == 2048;
    }

    public void setSampleCompositionTimeOffsetPresent(boolean v) {
        boolean bl = v;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.booleanObject(bl));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (v) {
            this.setFlags(this.getFlags() | 0x800);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FF);
        }
    }

    public int getDataOffset() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        int n = dataOffset;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (dataOffset == -1) {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.dataOffset = dataOffset;
    }

    public SampleFlags getFirstSampleFlags() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.firstSampleFlags;
    }

    public void setFirstSampleFlags(SampleFlags firstSampleFlags) {
        SampleFlags sampleFlags = firstSampleFlags;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_18, (Object)this, (Object)this, sampleFlags);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (firstSampleFlags == null) {
            this.setFlags(this.getFlags() & 0xFFFFFB);
        } else {
            this.setFlags(this.getFlags() | 4);
        }
        this.firstSampleFlags = firstSampleFlags;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_19, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        StringBuilder sb = new StringBuilder();
        sb.append("TrackRunBox");
        sb.append("{sampleCount=").append(this.entries.size());
        sb.append(", dataOffset=").append(this.dataOffset);
        sb.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        sb.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        sb.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        sb.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresent());
        sb.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        sb.append(", firstSampleFlags=").append(this.firstSampleFlags);
        sb.append('}');
        return sb.toString();
    }

    static {
        TrackRunBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackRunBox.java", TrackRunBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "java.util.List"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "java.util.List", "entries", "", "void"), 64);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleDurationPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "boolean", "v", "", "void"), 210);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleFlagsPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 219);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleFlagsPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "boolean", "v", "", "void"), 223);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleCompositionTimeOffsetPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 231);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleCompositionTimeOffsetPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "boolean", "v", "", "void"), 235);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataOffset", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "int"), 244);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffset", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "int", "dataOffset", "", "void"), 248);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstSampleFlags", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "org.mp4parser.boxes.iso14496.part12.SampleFlags"), 257);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFirstSampleFlags", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "org.mp4parser.boxes.iso14496.part12.SampleFlags", "firstSampleFlags", "", "void"), 261);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "java.lang.String"), 271);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCompositionTimeOffsets", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "[J"), 68);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCount", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "long"), 173);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDataOffsetPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 177);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataOffsetPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "boolean", "v", "", "void"), 181);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirstSampleFlagsPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 189);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleSizePresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 194);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSampleSizePresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "boolean", "v", "", "void"), 198);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSampleDurationPresent", "org.mp4parser.boxes.iso14496.part12.TrackRunBox", "", "", "", "boolean"), 206);
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private long sampleCompositionTimeOffset;

        public Entry() {
        }

        public Entry(long sampleDuration, long sampleSize, SampleFlags sampleFlags, int sampleCompositionTimeOffset) {
            this.sampleDuration = sampleDuration;
            this.sampleSize = sampleSize;
            this.sampleFlags = sampleFlags;
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public void setSampleDuration(long sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public void setSampleSize(long sampleSize) {
            this.sampleSize = sampleSize;
        }

        public SampleFlags getSampleFlags() {
            return this.sampleFlags;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public long getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleCompositionTimeOffset(int sampleCompositionTimeOffset) {
            this.sampleCompositionTimeOffset = sampleCompositionTimeOffset;
        }

        public String toString() {
            return "Entry{duration=" + this.sampleDuration + ", size=" + this.sampleSize + ", dlags=" + this.sampleFlags + ", compTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

