/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mp4parser.BoxParser;
import org.mp4parser.ParsableBox;
import org.mp4parser.tools.Hex;
import org.mp4parser.tools.IsoTypeReader;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());
    ThreadLocal<ByteBuffer> header = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(32);
        }
    };

    public abstract ParsableBox createBox(String var1, byte[] var2, String var3);

    public ParsableBox parseBox(ReadableByteChannel byteChannel, String parentType) throws IOException {
        long contentSize;
        int b;
        this.header.get().rewind().limit(8);
        int bytesRead = 0;
        while ((b = byteChannel.read(this.header.get())) + bytesRead < 8) {
            if (b < 0) {
                throw new EOFException();
            }
            bytesRead += b;
        }
        this.header.get().rewind();
        long size = IsoTypeReader.readUInt32(this.header.get());
        if (size < 8L && size > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + size + "). Stop parsing!");
            return null;
        }
        String type = IsoTypeReader.read4cc(this.header.get());
        byte[] usertype = null;
        if (size == 1L) {
            this.header.get().limit(16);
            byteChannel.read(this.header.get());
            this.header.get().position(8);
            size = IsoTypeReader.readUInt64(this.header.get());
            contentSize = size - 16L;
        } else {
            if (size == 0L) {
                throw new RuntimeException("box size of zero means 'till end of file. That is not yet supported");
            }
            contentSize = size - 8L;
        }
        if ("uuid".equals(type)) {
            this.header.get().limit(this.header.get().limit() + 16);
            byteChannel.read(this.header.get());
            usertype = new byte[16];
            int i = this.header.get().position() - 16;
            while (i < this.header.get().position()) {
                usertype[i - (this.header.get().position() - 16)] = this.header.get().get(i);
                ++i;
            }
            contentSize -= 16L;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Creating " + type + " " + Hex.encodeHex(new byte[]{this.header.get().get(4), this.header.get().get(5), this.header.get().get(6), this.header.get().get(7)}));
        }
        ParsableBox parsableBox = this.createBox(type, usertype, parentType);
        this.header.get().rewind();
        parsableBox.parse(byteChannel, this.header.get(), contentSize, this);
        return parsableBox;
    }
}

