/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.engine;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.engine.BindingsObject;
import org.mozilla.javascript.engine.Builtins;
import org.mozilla.javascript.engine.RhinoCompiledScript;
import org.mozilla.javascript.engine.RhinoInvocationHandler;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class RhinoScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    @Deprecated
    public static final String OPTIMIZATION_LEVEL = "org.mozilla.javascript.optimization_level";
    public static final String INTERPRETED_MODE = "org.mozilla.javascript.interpreted_mode";
    static final int DEFAULT_LANGUAGE_VERSION = 200;
    private static final boolean DEFAULT_DEBUG = true;
    private static final String DEFAULT_FILENAME = "eval";
    private static final CtxFactory ctxFactory = new CtxFactory();
    private final RhinoScriptEngineFactory factory;
    private final Builtins builtins;
    private ScriptableObject topLevelScope = null;

    RhinoScriptEngine(RhinoScriptEngineFactory factory) {
        this.factory = factory;
        this.builtins = new Builtins();
    }

    private Scriptable initScope(Context cx, ScriptContext sc) throws ScriptException {
        this.configureContext(cx);
        if (this.topLevelScope == null) {
            this.topLevelScope = cx.initStandardObjects();
            this.topLevelScope.associateValue(Builtins.BUILTIN_KEY, (Object)this.builtins);
            this.builtins.register(cx, this.topLevelScope, sc);
        }
        BindingsObject engineScope = new BindingsObject(sc.getBindings(100));
        engineScope.setParentScope(null);
        engineScope.setPrototype((Scriptable)this.topLevelScope);
        if (sc.getBindings(200) != null) {
            BindingsObject globalScope = new BindingsObject(sc.getBindings(200));
            globalScope.setParentScope(null);
            globalScope.setPrototype((Scriptable)this.topLevelScope);
            engineScope.setPrototype((Scriptable)globalScope);
        }
        return engineScope;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        Object object;
        block8: {
            Context cx = ctxFactory.enterContext();
            try {
                Scriptable scope = this.initScope(cx, context);
                Object ret = cx.evaluateString(scope, script, this.getFilename(), 0, null);
                object = Context.jsToJava((Object)ret, Object.class);
                if (cx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException re) {
                    throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
                }
            }
            cx.close();
        }
        return object;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Object object;
        block9: {
            Context cx = ctxFactory.enterContext();
            try {
                Scriptable scope = this.initScope(cx, context);
                Object ret = cx.evaluateReader(scope, reader, this.getFilename(), 0, null);
                object = Context.jsToJava((Object)ret, Object.class);
                if (cx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException re) {
                    throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
                }
                catch (IOException ioe) {
                    throw new ScriptException(ioe);
                }
            }
            cx.close();
        }
        return object;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        RhinoCompiledScript rhinoCompiledScript;
        block8: {
            Context cx = ctxFactory.enterContext();
            try {
                this.configureContext(cx);
                Script s = cx.compileString(script, this.getFilename(), 1, null);
                rhinoCompiledScript = new RhinoCompiledScript(this, s);
                if (cx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException re) {
                    throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
                }
            }
            cx.close();
        }
        return rhinoCompiledScript;
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript rhinoCompiledScript;
        block9: {
            Context cx = ctxFactory.enterContext();
            try {
                this.configureContext(cx);
                Script s = cx.compileReader(script, this.getFilename(), 1, null);
                rhinoCompiledScript = new RhinoCompiledScript(this, s);
                if (cx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException re) {
                    throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
                }
                catch (IOException ioe) {
                    throw new ScriptException(ioe);
                }
            }
            cx.close();
        }
        return rhinoCompiledScript;
    }

    Object eval(Script script, ScriptContext sc) throws ScriptException {
        Object object;
        block8: {
            Context cx = ctxFactory.enterContext();
            try {
                Scriptable scope = this.initScope(cx, sc);
                Object ret = script.exec(cx, scope, scope);
                object = Context.jsToJava((Object)ret, Object.class);
                if (cx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cx != null) {
                        try {
                            cx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RhinoException re) {
                    throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
                }
            }
            cx.close();
        }
        return object;
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(null, name, args);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethodRaw(thiz, name, Object.class, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object invokeMethodRaw(Object thiz, String name, Class<?> returnType, Object ... args) throws ScriptException, NoSuchMethodException {
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            Scriptable localThis = thiz == null ? scope : Context.toObject((Object)thiz, (Scriptable)scope);
            Object f = ScriptableObject.getProperty((Scriptable)localThis, (String)name);
            if (f == Scriptable.NOT_FOUND) {
                throw new NoSuchMethodException(name);
            }
            if (!(f instanceof Callable)) {
                throw new ScriptException("\"" + name + "\" is not a function");
            }
            Callable func = (Callable)f;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.javaToJS((Object)args[i], (Scriptable)scope);
                }
            }
            Object ret = func.call(cx, scope, localThis, args);
            if (returnType == Void.TYPE) {
                Object var11_15 = null;
                return var11_15;
            }
            Object object = Context.jsToJava((Object)ret, returnType);
            return object;
        }
        catch (RhinoException re) {
            throw new ScriptException(re.getMessage(), re.sourceName(), re.lineNumber(), re.columnNumber());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Class<T> clasz) {
        if (clasz == null) throw new IllegalArgumentException("Not an interface");
        if (!clasz.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            if (!RhinoScriptEngine.methodsMissing(scope, clasz)) return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clasz}, (InvocationHandler)new RhinoInvocationHandler(this, null));
            T t = null;
            return t;
        }
        catch (ScriptException se) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (clasz == null) throw new IllegalArgumentException("Not an interface");
        if (!clasz.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        try (Context cx = ctxFactory.enterContext();){
            Scriptable scope = this.initScope(cx, this.context);
            Scriptable thisObj = Context.toObject((Object)thiz, (Scriptable)scope);
            if (!RhinoScriptEngine.methodsMissing(thisObj, clasz)) return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clasz}, (InvocationHandler)new RhinoInvocationHandler(this, thiz));
            T t = null;
            return t;
        }
        catch (ScriptException se) {
            return null;
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    private void configureContext(Context cx) throws ScriptException {
        Object interpreted;
        Object ol;
        Object lv = this.get("javax.script.language_version");
        if (lv != null) {
            cx.setLanguageVersion(RhinoScriptEngine.parseInteger(lv));
        }
        if ((ol = this.get(OPTIMIZATION_LEVEL)) != null) {
            cx.setOptimizationLevel(RhinoScriptEngine.parseInteger(ol));
        }
        if ((interpreted = this.get(INTERPRETED_MODE)) != null) {
            cx.setInterpretedMode(RhinoScriptEngine.parseBoolean(interpreted));
        }
    }

    private static int parseInteger(Object v) throws ScriptException {
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException nfe) {
                throw new ScriptException("Invalid number " + String.valueOf(v));
            }
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        throw new ScriptException("Value must be a string or number");
    }

    private static boolean parseBoolean(Object v) throws ScriptException {
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        throw new ScriptException("Value must be a string or boolean");
    }

    private String getFilename() {
        Object fn = this.get("javax.script.filename");
        if (fn instanceof String) {
            return (String)fn;
        }
        return DEFAULT_FILENAME;
    }

    private static boolean methodsMissing(Scriptable scope, Class<?> clasz) {
        for (Method m : clasz.getMethods()) {
            Object methodObj;
            if (m.getDeclaringClass() == Object.class || (methodObj = ScriptableObject.getProperty((Scriptable)scope, (String)m.getName())) instanceof Callable) continue;
            return true;
        }
        return false;
    }

    private static final class CtxFactory
    extends ContextFactory {
        private CtxFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 18) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }

        protected void onContextCreated(Context cx) {
            cx.setLanguageVersion(200);
            cx.setGeneratingDebug(true);
        }
    }
}

