/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.support.utils.SafeBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001cJ\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\u0006J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\u0006J\u0016\u0010'\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0018J \u0010(\u001a\n\u0012\u0004\u0012\u0002H*\u0018\u00010)\"\b\b\u0000\u0010**\u00020+2\u0006\u0010!\u001a\u00020\u0006J\u001f\u0010,\u001a\u0004\u0018\u0001H*\"\b\b\u0000\u0010**\u00020+2\u0006\u0010!\u001a\u00020\u0006\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010)2\u0006\u0010!\u001a\u00020\u0006J\u0010\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0006R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lmozilla/components/support/utils/SafeIntent;", "", "unsafe", "Landroid/content/Intent;", "(Landroid/content/Intent;)V", "action", "", "getAction", "()Ljava/lang/String;", "categories", "", "getCategories", "()Ljava/util/Set;", "data", "Landroid/net/Uri;", "getData", "()Landroid/net/Uri;", "dataString", "getDataString", "extras", "Landroid/os/Bundle;", "getExtras", "()Landroid/os/Bundle;", "flags", "", "getFlags", "()I", "isLauncherIntent", "", "()Z", "getUnsafe", "()Landroid/content/Intent;", "getBooleanExtra", "name", "defaultValue", "getBundleExtra", "Lmozilla/components/support/utils/SafeBundle;", "getCharSequenceExtra", "", "getIntExtra", "getParcelableArrayListExtra", "Ljava/util/ArrayList;", "T", "Landroid/os/Parcelable;", "getParcelableExtra", "(Ljava/lang/String;)Landroid/os/Parcelable;", "getStringArrayListExtra", "getStringExtra", "hasExtra", "Companion", "utils_release"})
public final class SafeIntent {
    @NotNull
    private final Intent unsafe;
    private static final String LOGTAG;
    public static final Companion Companion;

    @Nullable
    public final Bundle getExtras() {
        try {
            return this.unsafe.getExtras();
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final String getAction() {
        return this.unsafe.getAction();
    }

    public final int getFlags() {
        return this.unsafe.getFlags();
    }

    @Nullable
    public final String getDataString() {
        try {
            return this.unsafe.getDataString();
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data string: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data string.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final Uri getData() {
        try {
            return this.unsafe.getData();
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final Set<String> getCategories() {
        try {
            return this.unsafe.getCategories();
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent categories: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent categories.", (Throwable)e);
            return null;
        }
    }

    public final boolean isLauncherIntent() {
        Set intentCategories = this.unsafe.getCategories();
        return intentCategories != null && intentCategories.contains("android.intent.category.LAUNCHER") && Intrinsics.areEqual((Object)"android.intent.action.MAIN", (Object)this.unsafe.getAction());
    }

    public final boolean hasExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.hasExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't determine if intent had an extra: OOM. Malformed?");
            return false;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't determine if intent had an extra.", (Throwable)e);
            return false;
        }
    }

    public final boolean getBooleanExtra(@NotNull String name, boolean defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getBooleanExtra(name, defaultValue);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return defaultValue;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return defaultValue;
        }
    }

    public final int getIntExtra(@NotNull String name, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getIntExtra(name, defaultValue);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return defaultValue;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return defaultValue;
        }
    }

    @Nullable
    public final String getStringExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getStringExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SafeBundle getBundleExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Bundle bundle = this.unsafe.getBundleExtra(name);
            return bundle != null ? new SafeBundle(bundle) : null;
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final CharSequence getCharSequenceExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getCharSequenceExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final <T extends Parcelable> T getParcelableExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return (T)this.unsafe.getParcelableExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getParcelableArrayListExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent extras.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final ArrayList<String> getStringArrayListExtra(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.unsafe.getStringArrayListExtra(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data string: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)SafeIntent.Companion.getLOGTAG(), (String)"Couldn't get intent data string.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final Intent getUnsafe() {
        return this.unsafe;
    }

    public SafeIntent(@NotNull Intent unsafe) {
        Intrinsics.checkParameterIsNotNull((Object)unsafe, (String)"unsafe");
        this.unsafe = unsafe;
    }

    static {
        Companion = new Companion(null);
        LOGTAG = "Gecko" + SafeIntent.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmozilla/components/support/utils/SafeIntent$Companion;", "", "()V", "LOGTAG", "", "getLOGTAG", "()Ljava/lang/String;", "utils_release"})
    public static final class Companion {
        private final String getLOGTAG() {
            return LOGTAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

