/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mozilla.components.support.utils.ThreadUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmozilla/components/support/utils/ThreadUtils;", "", "()V", "backgroundExecutorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getBackgroundExecutorService", "()Ljava/util/concurrent/ExecutorService;", "backgroundExecutorService$delegate", "Lkotlin/Lazy;", "handler", "Landroid/os/Handler;", "uiThread", "Ljava/lang/Thread;", "assertOnUiThread", "", "postToBackgroundThread", "runnable", "Ljava/lang/Runnable;", "postToMainThread", "postToMainThreadDelayed", "delayMillis", "", "utils_release"})
public final class ThreadUtils {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy backgroundExecutorService$delegate;
    private static final Handler handler;
    private static final Thread uiThread;
    public static final ThreadUtils INSTANCE;

    static {
        ThreadUtils threadUtils;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ThreadUtils.class), "backgroundExecutorService", "getBackgroundExecutorService()Ljava/util/concurrent/ExecutorService;"))};
        INSTANCE = threadUtils = new ThreadUtils();
        backgroundExecutorService$delegate = LazyKt.lazy((Function0)backgroundExecutorService.2.INSTANCE);
        handler = new Handler(Looper.getMainLooper());
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        uiThread = looper.getThread();
    }

    private final ExecutorService getBackgroundExecutorService() {
        Lazy lazy = backgroundExecutorService$delegate;
        ThreadUtils threadUtils = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ExecutorService)lazy.getValue();
    }

    public final void postToBackgroundThread(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        this.getBackgroundExecutorService().submit(runnable);
    }

    public final void postToMainThread(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        handler.post(runnable);
    }

    public final void postToMainThreadDelayed(@NotNull Runnable runnable, long delayMillis) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        handler.postDelayed(runnable, delayMillis);
    }

    public final void assertOnUiThread() {
        Thread currentThread;
        Thread thread = currentThread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
        long currentThreadId = thread.getId();
        Thread thread2 = uiThread;
        Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"uiThread");
        long expectedThreadId = thread2.getId();
        if (currentThreadId == expectedThreadId) {
            return;
        }
        throw (Throwable)new IllegalThreadStateException("Expected UI thread, but running on " + currentThread.getName());
    }

    private ThreadUtils() {
    }
}

