/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils;

import android.os.Bundle;
import android.os.Parcelable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.support.base.log.logger.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lmozilla/components/support/utils/SafeBundle;", "", "bundle", "Landroid/os/Bundle;", "(Landroid/os/Bundle;)V", "getParcelable", "T", "Landroid/os/Parcelable;", "name", "", "(Ljava/lang/String;)Landroid/os/Parcelable;", "getString", "utils_release"})
public final class SafeBundle {
    private final Bundle bundle;

    @Nullable
    public final String getString(@NotNull String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            string = this.bundle.getString(name);
        }
        catch (OutOfMemoryError e) {
            Logger.Companion.warn$default((Logger.Companion)Logger.Companion, (String)"Couldn't get bundle items: OOM. Malformed?", null, (int)2, null);
            string = null;
        }
        catch (RuntimeException e) {
            Logger.Companion.warn("Couldn't get bundle items.", (Throwable)e);
            string = null;
        }
        return string;
    }

    @Nullable
    public final <T extends Parcelable> T getParcelable(@NotNull String name) {
        Parcelable parcelable;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            parcelable = this.bundle.getParcelable(name);
        }
        catch (OutOfMemoryError e) {
            Logger.Companion.warn$default((Logger.Companion)Logger.Companion, (String)"Couldn't get bundle items: OOM. Malformed?", null, (int)2, null);
            parcelable = null;
        }
        catch (RuntimeException e) {
            Logger.Companion.warn("Couldn't get bundle items.", (Throwable)e);
            parcelable = null;
        }
        return (T)parcelable;
    }

    public SafeBundle(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.bundle = bundle;
    }
}

