/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.utils;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0003J&\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmozilla/components/utils/DownloadUtils;", "", "()V", "CONTENT_DISPOSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ENCODED_SYMBOL_PATTERN", "decodeHeaderField", "", "field", "encoding", "guessFileName", "contentDisposition", "url", "mimeType", "parseContentDisposition", "utils_release"})
public final class DownloadUtils {
    private static final Pattern CONTENT_DISPOSITION_PATTERN;
    private static final Pattern ENCODED_SYMBOL_PATTERN;
    public static final DownloadUtils INSTANCE;

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final String guessFileName(@Nullable String contentDisposition, @Nullable String url, @Nullable String mimeType) {
        block14: {
            block13: {
                filename = null;
                extension = null;
                if (contentDisposition != null && (filename = DownloadUtils.INSTANCE.parseContentDisposition(contentDisposition)) != null && (index = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'/', (int)0, (boolean)false, (int)6, null) + 1) > 0) {
                    var6_7 = filename;
                    v0 = var6_7.substring(index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"(this as java.lang.String).substring(startIndex)");
                    filename = v0;
                }
                if (filename == null && (decodedUrl = Uri.decode((String)url)) != null) {
                    queryIndex = StringsKt.indexOf$default((CharSequence)decodedUrl, (char)'?', (int)0, (boolean)false, (int)6, null);
                    if (queryIndex > 0) {
                        var7_10 = decodedUrl;
                        var8_13 = 0;
                        v1 = var7_10.substring(var8_13, queryIndex);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        decodedUrl = v1;
                    }
                    if (!StringsKt.endsWith$default((String)decodedUrl, (String)"/", (boolean)false, (int)2, null) && (index = StringsKt.lastIndexOf$default((CharSequence)decodedUrl, (char)'/', (int)0, (boolean)false, (int)6, null) + 1) > 0) {
                        v2 = var8_14 = decodedUrl;
                        if (v2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        v3 = v2.substring(index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.String).substring(startIndex)");
                        filename = v3;
                    }
                }
                if (filename == null) {
                    filename = "downloadfile";
                }
                if ((dotIndex = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null)) >= 0) break block13;
                if (mimeType != null && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                    extension = "." + extension;
                }
                if (extension != null) break block14;
                if (mimeType == null) ** GOTO lbl-1000
                queryIndex = mimeType;
                v4 = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"Locale.ROOT");
                index = v4;
                v5 = queryIndex.toLowerCase(index);
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(this as java.lang.String).toLowerCase(locale)");
                if (StringsKt.startsWith$default((String)v5, (String)"text/", (boolean)false, (int)2, null)) {
                    extension = StringsKt.equals((String)mimeType, (String)"text/html", (boolean)true) ? ".html" : ".txt";
                } else lbl-1000:
                // 2 sources

                {
                    extension = ".bin";
                }
                break block14;
            }
            if (mimeType != null) {
                lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
                var8_15 = filename;
                var9_16 = lastDotIndex + 1;
                var10_17 = MimeTypeMap.getSingleton();
                v6 = var8_15.substring(var9_16);
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"(this as java.lang.String).substring(startIndex)");
                var11_18 = v6;
                typeFromExt = var10_17.getMimeTypeFromExtension(var11_18);
                if (typeFromExt != null && !StringsKt.equals((String)typeFromExt, (String)mimeType, (boolean)true) && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                    extension = "." + extension;
                }
            }
            if (extension == null) {
                var6_7 = filename;
                v7 = var6_7.substring(dotIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"(this as java.lang.String).substring(startIndex)");
                extension = v7;
            }
            var6_7 = filename;
            var7_12 = 0;
            v8 = var6_7.substring(var7_12, dotIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            filename = v8;
        }
        v9 = new StringBuilder().append(filename);
        v10 = extension;
        if (v10 == null) {
            Intrinsics.throwNpe();
        }
        return v9.append(v10).toString();
    }

    private final String parseContentDisposition(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                String string;
                String encodedFileName = m.group(4);
                String encoding = m.group(3);
                if (encodedFileName != null) {
                    String string2 = encoding;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"encoding");
                    return this.decodeHeaderField(encodedFileName, string2);
                }
                String quotedFileName = m.group(2);
                if (quotedFileName != null) {
                    CharSequence charSequence = quotedFileName;
                    String string3 = "\\\\(.)";
                    string3 = new Regex(string3);
                    String string4 = "$1";
                    string = string3.replace(charSequence, string4);
                } else {
                    string = m.group(1);
                }
                return string;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    private final String decodeHeaderField(String field, String encoding) throws UnsupportedEncodingException {
        Matcher m = ENCODED_SYMBOL_PATTERN.matcher(field);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (m.find()) {
            String symbol;
            String string = symbol = m.group();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"symbol");
            if (StringsKt.startsWith$default((String)string, (String)"%", (boolean)false, (int)2, null)) {
                String string2;
                String string3 = symbol;
                int n = 1;
                ByteArrayOutputStream byteArrayOutputStream = stream;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                byteArrayOutputStream.write(Integer.parseInt(string2, 16));
                continue;
            }
            stream.write(symbol.charAt(0));
        }
        String string = stream.toString(encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stream.toString(encoding)");
        return string;
    }

    private DownloadUtils() {
    }

    static {
        DownloadUtils downloadUtils;
        INSTANCE = downloadUtils = new DownloadUtils();
        CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment\\s*;\\s*filename\\s*=\\s*(\"((?:\\\\.|[^\"\\\\])*)\"|[^;]*)\\s*(?:;\\s*filename\\*\\s*=\\s*(utf-8|iso-8859-1)'[^']*'(\\S*))?", 2);
        ENCODED_SYMBOL_PATTERN = Pattern.compile("%[0-9a-f]{2}|[0-9a-z!#$&+-.^_`|~]", 2);
    }
}

