/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils.observer;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.support.utils.observer.Observable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\fH\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmozilla/components/support/utils/observer/ObserverRegistry;", "T", "Lmozilla/components/support/utils/observer/Observable;", "()V", "lifecycleObservers", "Ljava/util/WeakHashMap;", "Lmozilla/components/support/utils/observer/ObserverRegistry$LifecycleBoundObserver;", "observers", "", "viewObservers", "Lmozilla/components/support/utils/observer/ObserverRegistry$ViewBoundObserver;", "notifyObservers", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "register", "observer", "(Ljava/lang/Object;)V", "owner", "Landroid/arch/lifecycle/LifecycleOwner;", "(Ljava/lang/Object;Landroid/arch/lifecycle/LifecycleOwner;)V", "view", "Landroid/view/View;", "(Ljava/lang/Object;Landroid/view/View;)V", "unregister", "unregisterObservers", "LifecycleBoundObserver", "ViewBoundObserver", "utils_release"})
public final class ObserverRegistry<T>
implements Observable<T> {
    private final List<T> observers;
    private final WeakHashMap<T, LifecycleBoundObserver<T>> lifecycleObservers;
    private final WeakHashMap<T, ViewBoundObserver<T>> viewObservers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(T observer) {
        List<T> list = this.observers;
        synchronized (list) {
            boolean bl = this.observers.add(observer);
        }
    }

    @Override
    public void register(T observer, @NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Lifecycle lifecycle = owner.getLifecycle();
        Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"owner.lifecycle");
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        this.register(observer);
        LifecycleBoundObserver<T> lifecycleObserver = new LifecycleBoundObserver<T>(owner, this, observer);
        Map map = this.lifecycleObservers;
        LifecycleBoundObserver<T> lifecycleBoundObserver = lifecycleObserver;
        map.put(observer, lifecycleBoundObserver);
        owner.getLifecycle().addObserver((LifecycleObserver)lifecycleObserver);
    }

    @Override
    public void register(T observer, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (!view.isAttachedToWindow()) {
            return;
        }
        this.register(observer);
        ViewBoundObserver<T> viewObserver = new ViewBoundObserver<T>(view, this, observer);
        Map map = this.viewObservers;
        ViewBoundObserver<T> viewBoundObserver = viewObserver;
        map.put(observer, viewBoundObserver);
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)viewObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(T observer) {
        block4: {
            List<T> list = this.observers;
            synchronized (list) {
                boolean bl = this.observers.remove(observer);
            }
            LifecycleBoundObserver<T> lifecycleBoundObserver = this.lifecycleObservers.get(observer);
            if (lifecycleBoundObserver != null) {
                lifecycleBoundObserver.remove();
            }
            ViewBoundObserver<T> viewBoundObserver = this.viewObservers.get(observer);
            if (viewBoundObserver == null) break block4;
            viewBoundObserver.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObservers() {
        List<T> list = this.observers;
        synchronized (list) {
            Iterable $receiver$iv = this.observers;
            Unit unit = $receiver$iv.iterator();
            while (unit.hasNext()) {
                Object element$iv;
                Object it = element$iv = unit.next();
                LifecycleBoundObserver<T> lifecycleBoundObserver = this.lifecycleObservers.get(it);
                if (lifecycleBoundObserver == null) continue;
                lifecycleBoundObserver.remove();
            }
            this.observers.clear();
            unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        List<T> list = this.observers;
        synchronized (list) {
            Iterable $receiver$iv = this.observers;
            Unit unit = $receiver$iv.iterator();
            while (unit.hasNext()) {
                Object element$iv;
                Object it = element$iv = unit.next();
                block.invoke(it);
            }
            unit = Unit.INSTANCE;
        }
    }

    public ObserverRegistry() {
        List list;
        ObserverRegistry observerRegistry = this;
        observerRegistry.observers = list = (List)new ArrayList();
        this.lifecycleObservers = new WeakHashMap();
        this.viewObservers = new WeakHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000bR\u0010\u0010\u0007\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmozilla/components/support/utils/observer/ObserverRegistry$LifecycleBoundObserver;", "T", "Landroid/arch/lifecycle/GenericLifecycleObserver;", "owner", "Landroid/arch/lifecycle/LifecycleOwner;", "registry", "Lmozilla/components/support/utils/observer/ObserverRegistry;", "observer", "(Landroid/arch/lifecycle/LifecycleOwner;Lmozilla/components/support/utils/observer/ObserverRegistry;Ljava/lang/Object;)V", "Ljava/lang/Object;", "onStateChanged", "", "source", "event", "Landroid/arch/lifecycle/Lifecycle$Event;", "remove", "utils_release"})
    private static final class LifecycleBoundObserver<T>
    implements GenericLifecycleObserver {
        private final LifecycleOwner owner;
        private final ObserverRegistry<T> registry;
        private final T observer;

        public void onStateChanged(@Nullable LifecycleOwner source, @Nullable Lifecycle.Event event) {
            Lifecycle lifecycle = this.owner.getLifecycle();
            Intrinsics.checkExpressionValueIsNotNull((Object)lifecycle, (String)"owner.lifecycle");
            if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
                this.registry.unregister(this.observer);
            }
        }

        public final void remove() {
            this.owner.getLifecycle().removeObserver((LifecycleObserver)this);
        }

        public LifecycleBoundObserver(@NotNull LifecycleOwner owner, @NotNull ObserverRegistry<T> registry, T observer) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
            this.owner = owner;
            this.registry = registry;
            this.observer = observer;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0006\u0010\r\u001a\u00020\u000bR\u0010\u0010\u0007\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmozilla/components/support/utils/observer/ObserverRegistry$ViewBoundObserver;", "T", "Landroid/view/View$OnAttachStateChangeListener;", "view", "Landroid/view/View;", "registry", "Lmozilla/components/support/utils/observer/ObserverRegistry;", "observer", "(Landroid/view/View;Lmozilla/components/support/utils/observer/ObserverRegistry;Ljava/lang/Object;)V", "Ljava/lang/Object;", "onViewAttachedToWindow", "", "onViewDetachedFromWindow", "remove", "utils_release"})
    private static final class ViewBoundObserver<T>
    implements View.OnAttachStateChangeListener {
        private final View view;
        private final ObserverRegistry<T> registry;
        private final T observer;

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.registry.unregister(this.observer);
        }

        public final void remove() {
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        }

        public ViewBoundObserver(@NotNull View view, @NotNull ObserverRegistry<T> registry, T observer) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
            this.view = view;
            this.registry = registry;
            this.observer = observer;
        }
    }
}

