/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmozilla/components/support/utils/SafeBundle;", "", "bundle", "Landroid/os/Bundle;", "(Landroid/os/Bundle;)V", "getParcelable", "T", "Landroid/os/Parcelable;", "name", "", "(Ljava/lang/String;)Landroid/os/Parcelable;", "getString", "Companion", "utils_release"})
public final class SafeBundle {
    private final Bundle bundle;
    private static final String LOGTAG;
    public static final Companion Companion;

    @Nullable
    public final String getString(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.bundle.getString(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)LOGTAG, (String)"Couldn't get bundle items: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)LOGTAG, (String)"Couldn't get bundle items.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final <T extends Parcelable> T getParcelable(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return (T)this.bundle.getParcelable(name);
        }
        catch (OutOfMemoryError e) {
            Log.w((String)LOGTAG, (String)"Couldn't get bundle items: OOM. Malformed?");
            return null;
        }
        catch (RuntimeException e) {
            Log.w((String)LOGTAG, (String)"Couldn't get bundle items.", (Throwable)e);
            return null;
        }
    }

    public SafeBundle(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        this.bundle = bundle;
    }

    static {
        Companion = new Companion(null);
        LOGTAG = SafeBundle.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmozilla/components/support/utils/SafeBundle$Companion;", "", "()V", "LOGTAG", "", "kotlin.jvm.PlatformType", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

