/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package mozilla.components.ktx.kotlin

/**
 * A series of dots (typically three, such as "…") that usually indicates an intentional omission of
 * a word, sentence, or whole section from a text without altering its original meaning.
 */
val Char.Companion.ELLIPSIS: Char
    get() = '…'
