/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import android.content.Context;
import android.util.AtomicFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mozilla.components.browser.session.Session;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.session.storage.SessionStorage;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J$\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0017J(\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u0016\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0015\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lmozilla/components/feature/session/DefaultSessionStorage;", "Lmozilla/components/concept/session/storage/SessionStorage;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deserializeEngineSession", "Lmozilla/components/concept/engine/EngineSession;", "engine", "Lmozilla/components/concept/engine/Engine;", "json", "Lorg/json/JSONObject;", "deserializeSession", "Lmozilla/components/browser/session/Session;", "id", "", "deserializeSession$feature_session_release", "getFile", "Landroid/util/AtomicFile;", "getFile$feature_session_release", "persist", "", "sessions", "", "selectedSession", "restore", "Lkotlin/Pair;", "serializeEngineSession", "engineSession", "serializeSession", "session", "serializeSession$feature_session_release", "feature-session_release"})
public final class DefaultSessionStorage
implements SessionStorage {
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized Pair<Map<Session, EngineSession>, String> restore(@NotNull Engine engine) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        try {
            Pair pair2;
            Map sessions = new LinkedHashMap();
            Closeable closeable = this.getFile$feature_session_release().openRead();
            Throwable throwable = null;
            try {
                FileInputStream it;
                FileInputStream fileInputStream = it = (FileInputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileInputStream, (String)"it");
                Closeable closeable2 = fileInputStream;
                Object object = Charsets.UTF_8;
                Object object2 = closeable2;
                object2 = new InputStreamReader((InputStream)object2, (Charset)object);
                int n = 8192;
                closeable2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    Object it2 = (BufferedReader)closeable2;
                    it2 = TextStreamsKt.readText((Reader)((Reader)it2));
                }
                catch (Throwable it2) {
                    object = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                Object json = it2;
                JSONObject jsonRoot = new JSONObject((String)json);
                String selectedSessionId = jsonRoot.getString("selectedSession");
                jsonRoot.remove("selectedSession");
                jsonRoot.remove("version");
                Iterator iterator = jsonRoot.keys();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"jsonRoot.keys()");
                Iterator $receiver$iv = iterator;
                Object object3 = object2 = $receiver$iv;
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    String it3 = (String)element$iv;
                    JSONObject jsonSession = jsonRoot.getJSONObject(it3);
                    String string = it3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    JSONObject jSONObject = jsonSession.getJSONObject("session");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"jsonSession.getJSONObject(SESSION_KEY)");
                    Session session = this.deserializeSession$feature_session_release(string, jSONObject);
                    JSONObject jSONObject2 = jsonSession.getJSONObject("engineSession");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"jsonSession.getJSONObject(ENGINE_SESSION_KEY)");
                    EngineSession engineSession = this.deserializeEngineSession(engine, jSONObject2);
                    Map map = sessions;
                    EngineSession engineSession2 = engineSession;
                    map.put(session, engineSession2);
                }
                pair2 = new Pair((Object)sessions, (Object)selectedSessionId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            pair = pair2;
        }
        catch (IOException _) {
            pair = new Pair((Object)MapsKt.emptyMap(), (Object)"");
        }
        catch (JSONException _) {
            pair = new Pair((Object)MapsKt.emptyMap(), (Object)"");
        }
        return pair;
    }

    public synchronized boolean persist(@NotNull Map<Session, ? extends EngineSession> sessions, @NotNull String selectedSession) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(sessions, (String)"sessions");
        Intrinsics.checkParameterIsNotNull((Object)selectedSession, (String)"selectedSession");
        AtomicFile file = null;
        FileOutputStream outputStream = null;
        try {
            Object $receiver$iv;
            JSONObject json = new JSONObject();
            json.put("version", 1);
            json.put("selectedSession", (Object)selectedSession);
            Object object = $receiver$iv = sessions;
            Iterator<Map.Entry<Session, ? extends EngineSession>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Session, ? extends EngineSession> element$iv;
                Map.Entry<Session, ? extends EngineSession> $session_engineSession;
                Map.Entry<Session, ? extends EngineSession> entry = $session_engineSession = (element$iv = iterator.next());
                Session session = entry.getKey();
                entry = $session_engineSession;
                EngineSession engineSession = entry.getValue();
                JSONObject sessionJson = new JSONObject();
                sessionJson.put("session", (Object)this.serializeSession$feature_session_release(session));
                sessionJson.put("engineSession", (Object)this.serializeEngineSession(engineSession));
                json.put(session.getId(), (Object)sessionJson);
            }
            file = this.getFile$feature_session_release();
            outputStream = file.startWrite();
            String string = json.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.toString()");
            $receiver$iv = string;
            FileOutputStream fileOutputStream = outputStream;
            object = Charsets.UTF_8;
            Object object2 = $receiver$iv;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object2).getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            fileOutputStream.write(byArray2);
            file.finishWrite(outputStream);
            bl = true;
        }
        catch (IOException _) {
            AtomicFile atomicFile = file;
            if (atomicFile != null) {
                atomicFile.failWrite(outputStream);
            }
            bl = false;
        }
        catch (JSONException _) {
            AtomicFile atomicFile = file;
            if (atomicFile != null) {
                atomicFile.failWrite(outputStream);
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final AtomicFile getFile$feature_session_release() {
        return new AtomicFile(new File(this.context.getFilesDir(), "mozilla_components_session_storage.json"));
    }

    @NotNull
    public final JSONObject serializeSession$feature_session_release(@NotNull Session session) throws JSONException {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        JSONObject json = new JSONObject();
        json.put("url", (Object)session.getUrl());
        return json;
    }

    @NotNull
    public final Session deserializeSession$feature_session_release(@NotNull String id, @NotNull JSONObject json) throws JSONException {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = json.getString("url");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"url\")");
        return new Session(string, id);
    }

    private final JSONObject serializeEngineSession(EngineSession engineSession) {
        return new JSONObject();
    }

    private final EngineSession deserializeEngineSession(Engine engine, JSONObject json) {
        return engine.createSession();
    }

    public DefaultSessionStorage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

