/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.engine.EngineView;
import mozilla.components.feature.session.SessionMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmozilla/components/feature/session/EngineViewPresenter;", "Lmozilla/components/browser/session/SessionManager$Observer;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "engine", "Lmozilla/components/concept/engine/Engine;", "engineView", "Lmozilla/components/concept/engine/EngineView;", "sessionMapping", "Lmozilla/components/feature/session/SessionMapping;", "(Lmozilla/components/browser/session/SessionManager;Lmozilla/components/concept/engine/Engine;Lmozilla/components/concept/engine/EngineView;Lmozilla/components/feature/session/SessionMapping;)V", "onSessionSelected", "", "session", "Lmozilla/components/browser/session/Session;", "renderSession", "start", "stop", "feature-session_release"})
public final class EngineViewPresenter
implements SessionManager.Observer {
    private final SessionManager sessionManager;
    private final Engine engine;
    private final EngineView engineView;
    private final SessionMapping sessionMapping;

    public final void start() {
        this.renderSession(this.sessionManager.getSelectedSession());
        this.sessionManager.register((SessionManager.Observer)this);
    }

    public final void stop() {
        this.sessionManager.unregister((SessionManager.Observer)this);
    }

    public void onSessionSelected(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.renderSession(session);
    }

    private final void renderSession(Session session) {
        EngineSession engineSession = this.sessionMapping.getOrCreate(this.engine, session);
        this.engineView.render(engineSession);
    }

    public EngineViewPresenter(@NotNull SessionManager sessionManager, @NotNull Engine engine, @NotNull EngineView engineView, @NotNull SessionMapping sessionMapping) {
        Intrinsics.checkParameterIsNotNull((Object)sessionManager, (String)"sessionManager");
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)engineView, (String)"engineView");
        Intrinsics.checkParameterIsNotNull((Object)sessionMapping, (String)"sessionMapping");
        this.sessionManager = sessionManager;
        this.engine = engine;
        this.engineView = engineView;
        this.sessionMapping = sessionMapping;
    }
}

