/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.browser.domains;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007J)\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lmozilla/components/browser/domains/Domains;", "", "()V", "getAvailableDomainLists", "", "", "context", "Landroid/content/Context;", "getCountriesInDefaultLocaleList", "load", "", "countries", "load$domains_release", "loadDomainsForLanguage", "", "domains", "", "country", "domains_release"})
public final class Domains {
    public static final Domains INSTANCE;

    @NotNull
    public final List<String> load(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.load$domains_release(context, this.getCountriesInDefaultLocaleList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> load$domains_release(@NotNull Context context, @NotNull Set<String> countries) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(countries, (String)"countries");
        LinkedHashSet domains2 = new LinkedHashSet();
        Set<String> availableLists = this.getAvailableDomainLists(context);
        Iterable iterable = countries;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!availableLists.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            INSTANCE.loadDomainsForLanguage(context, domains2, it);
        }
        this.loadDomainsForLanguage(context, domains2, "global");
        return CollectionsKt.toList((Iterable)domains2);
    }

    private final Set<String> getAvailableDomainLists(Context context) {
        Object[] objectArray;
        LinkedHashSet availableDomains = new LinkedHashSet();
        AssetManager assetManager = context.getAssets();
        try {
            objectArray = assetManager.list("domains");
        }
        catch (IOException e) {
            objectArray = new String[]{};
        }
        Object[] domains2 = objectArray;
        Collection collection = availableDomains;
        Intrinsics.checkExpressionValueIsNotNull((Object)domains2, (String)"domains");
        CollectionsKt.addAll((Collection)collection, (Object[])domains2);
        return availableDomains;
    }

    private final void loadDomainsForLanguage(Context context, Set<String> domains2, String country) {
        Object object;
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open("domains/" + country);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"assetManager.open(\"domains/\" + country)");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            Object object2 = object;
            object2 = new InputStreamReader((InputStream)object2, charset);
            int n = 8192;
            object = TextStreamsKt.readLines((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
        }
        catch (IOException e) {
            object = CollectionsKt.emptyList();
        }
        List languageDomains = object;
        domains2.addAll(languageDomains);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getCountriesInDefaultLocaleList() {
        LinkedHashSet countries = new LinkedHashSet();
        Function1 addIfNotEmpty2 = (Function1)new Function1<String, Unit>(countries){
            final /* synthetic */ LinkedHashSet $countries;

            public final void invoke(@NotNull String c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                if (!TextUtils.isEmpty((CharSequence)c)) {
                    String string = c;
                    Locale locale = Locale.US;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                    Locale locale2 = locale;
                    LinkedHashSet linkedHashSet = this.$countries;
                    String string2 = string.toLowerCase(locale2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
                    String string3 = string2;
                    linkedHashSet.add(string3);
                }
            }
            {
                this.$countries = linkedHashSet;
                super(1);
            }
        };
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList list = LocaleList.getDefault();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                void i;
                Locale locale = list.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"list.get(i)");
                String string = locale.getCountry();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"list.get(i).country");
                addIfNotEmpty2.invoke((Object)string);
                ++i;
            }
        } else {
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            String string = locale.getCountry();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().country");
            addIfNotEmpty2.invoke((Object)string);
        }
        return countries;
    }

    private Domains() {
    }

    static {
        Domains domains2;
        INSTANCE = domains2 = new Domains();
    }
}

