/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.daemon;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Timer;
import java.util.TimerTask;

public class Sweeper
implements Runnable,
FilenameFilter {
    public static final long DEFAULT_INTERVAL = 3600000L;
    public static boolean LOG_TO_CONSOLE = true;

    public Sweeper() {
    }

    public Sweeper(long interval) {
        if (interval == 0L) {
            this.run();
        } else {
            this.schedule(new Timer(), interval);
        }
    }

    public Sweeper(Timer timer, long interval) {
        this.schedule(timer, interval);
    }

    private void schedule(Timer timer, long interval) {
        if (LOG_TO_CONSOLE) {
            System.err.println("Sweeping " + System.getProperty("java.io.tmpdir") + " every " + interval + "ms");
        }
        timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                Sweeper.this.run();
            }
        }, 1000L, interval);
    }

    public void run() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File[] files = tmpDir.listFiles(this);
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            File sentinel = new File(dir, ".active");
            if (sentinel.exists() || !Sweeper.delete(dir) || !LOG_TO_CONSOLE) continue;
            System.err.println("removed dir: " + dir);
        }
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Sweeper.delete(files[i]);
            }
        }
        return file.delete();
    }

    public boolean accept(File file, String name) {
        return name.startsWith("Jetty_") && file.isDirectory();
    }

    public static void main(String[] args) {
        new Sweeper(args.length != 0 ? Long.parseLong(args[0]) : Long.getLong("interval", 3600000L));
    }
}

