/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.start;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.mortbay.start.Main;

public class Monitor
extends Thread {
    private int _port = Integer.getInteger("STOP.PORT", 8079);
    private String _key = System.getProperty("STOP.KEY", "mortbay");
    ServerSocket _socket;

    Monitor() {
        try {
            if (this._port < 0) {
                return;
            }
            this.setDaemon(true);
            this._socket = new ServerSocket(this._port, 1, InetAddress.getByName("127.0.0.1"));
            if (this._port == 0) {
                this._port = this._socket.getLocalPort();
                System.out.println(this._port);
            }
            if (!"mortbay".equals(this._key)) {
                this._key = Long.toString((long)(9.223372036854776E18 * Math.random()), 36);
                System.out.println(this._key);
            }
        }
        catch (Exception e) {
            if (Main._debug) {
                e.printStackTrace();
            }
            System.err.println(e.toString());
        }
        if (this._socket != null) {
            this.start();
        } else {
            System.err.println("WARN: Not listening on monitor port: " + this._port);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                try {
                    socket = this._socket.accept();
                    LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                    String key = lin.readLine();
                    if (!this._key.equals(key)) continue;
                    String cmd = lin.readLine();
                    if (Main._debug) {
                        System.err.println("command=" + cmd);
                    }
                    if ("stop".equals(cmd)) {
                        try {
                            socket.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            this._socket.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.exit(0);
                        continue;
                    }
                    if (!"status".equals(cmd)) continue;
                    socket.getOutputStream().write("OK\r\n".getBytes());
                    socket.getOutputStream().flush();
                    continue;
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                    socket = null;
                    continue;
                }
            }
            catch (Exception e) {
                if (Main._debug) {
                    e.printStackTrace();
                    continue;
                }
                System.err.println(e.toString());
                continue;
            }
            break;
        }
    }

    public static void monitor() {
        new Monitor();
    }
}

