/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.server.ClientDelegate;
import org.mortbay.jetty.rhttp.server.ExternalRequest;
import org.mortbay.jetty.rhttp.server.Gateway;
import org.mortbay.jetty.rhttp.server.TargetIdRetriever;

public class ExternalServlet
extends HttpServlet {
    private final Logger logger = Log.getLogger((String)((Object)((Object)this)).getClass().toString());
    private final Gateway gateway;
    private final TargetIdRetriever targetIdRetriever;

    public ExternalServlet(Gateway gateway, TargetIdRetriever targetIdRetriever) {
        this.gateway = gateway;
        this.targetIdRetriever = targetIdRetriever;
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        this.logger.debug("External http request: {}", new Object[]{httpRequest.getRequestURL()});
        String targetId = this.targetIdRetriever.retrieveTargetId(httpRequest);
        if (targetId == null) {
            throw new ServletException("Invalid request to " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + httpRequest.getRequestURI());
        }
        ClientDelegate client = this.gateway.getClientDelegate(targetId);
        if (client == null) {
            throw new ServletException("Client with targetId " + targetId + " is not connected");
        }
        ExternalRequest externalRequest = this.gateway.newExternalRequest(httpRequest, httpResponse);
        RHTTPRequest request = externalRequest.getRequest();
        ExternalRequest existing = this.gateway.addExternalRequest(request.getId(), externalRequest);
        assert (existing == null);
        this.logger.debug("External request {} for device {}", new Object[]{request, targetId});
        boolean delivered = client.enqueue(request);
        if (!delivered) {
            throw new ServletException("Could not enqueue request to client with targetId " + targetId);
        }
        externalRequest.suspend();
    }
}

