/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.server;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.mortbay.jetty.rhttp.server.GatewayServer;
import org.mortbay.jetty.rhttp.server.HostTargetIdRetriever;
import org.mortbay.jetty.rhttp.server.TargetIdRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String PORT_ARG = "port";
    private static final String RESOURCES_ARG = "resources";
    private static final String RETRIEVER_ARG = "retriever";

    public static void main(String[] args) throws Exception {
        Map<String, Object> arguments = Main.parse(args);
        System.out.println("arguments = " + arguments);
        int port = 8080;
        if (arguments.containsKey(PORT_ARG)) {
            port = (Integer)arguments.get(PORT_ARG);
        }
        String resources = null;
        if (arguments.containsKey(RESOURCES_ARG)) {
            resources = (String)arguments.get(RESOURCES_ARG);
        }
        TargetIdRetriever retriever = null;
        if (arguments.containsKey(RETRIEVER_ARG)) {
            retriever = (TargetIdRetriever)arguments.get(RETRIEVER_ARG);
        }
        GatewayServer server = new GatewayServer();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        server.addConnector((Connector)connector);
        if (resources != null) {
            server.setResourcesPath(resources);
        }
        if (retriever != null) {
            server.setTargetIdRetriever(retriever);
        }
        server.start();
    }

    private static Map<String, Object> parse(String[] args) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Pattern pattern = Pattern.compile("--([^=]+)=(.+)");
        for (String arg : args) {
            String argValue;
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.matches()) continue;
            String argName = matcher.group(1);
            if (PORT_ARG.equals(argName)) {
                result.put(PORT_ARG, Integer.parseInt(matcher.group(2)));
                continue;
            }
            if (RESOURCES_ARG.equals(argName)) {
                argValue = matcher.group(2);
                result.put(RESOURCES_ARG, argValue);
                continue;
            }
            if (!RETRIEVER_ARG.equals(argName) || !(argValue = matcher.group(2)).startsWith("host,")) continue;
            String[] typeAndSuffix = argValue.split(",");
            if (typeAndSuffix.length != 2) {
                throw new IllegalArgumentException("Invalid option " + arg + ", must be of the form --" + RETRIEVER_ARG + "=host,suffix");
            }
            result.put(RETRIEVER_ARG, new HostTargetIdRetriever(typeAndSuffix[1]));
        }
        return result;
    }
}

