/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.gateway;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;
import org.mortbay.jetty.rhttp.gateway.ExternalRequest;
import org.mortbay.jetty.rhttp.gateway.Gateway;

public class StandardExternalRequest
implements ExternalRequest {
    private final Logger logger = Log.getLogger((String)this.getClass().toString());
    private final RHTTPRequest request;
    private final HttpServletRequest httpRequest;
    private final HttpServletResponse httpResponse;
    private final Gateway gateway;
    private final Object lock = new Object();
    private volatile long timeout;
    private Continuation continuation;
    private boolean responded;

    public StandardExternalRequest(RHTTPRequest request, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Gateway gateway) {
        this.request = request;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.gateway = gateway;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspend() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responded) {
                assert (this.continuation == null);
                this.continuation = ContinuationSupport.getContinuation((ServletRequest)this.httpRequest);
                this.continuation.setTimeout(this.getTimeout());
                this.continuation.addContinuationListener((ContinuationListener)new TimeoutListener());
                this.continuation.suspend((ServletResponse)this.httpResponse);
                this.logger.debug("Request {} suspended", new Object[]{this.getRequest()});
            } else {
                this.logger.debug("Request {} already responded", new Object[]{this.getRequest()});
            }
            return !this.responded;
        }
    }

    @Override
    public void respond(RHTTPResponse response) throws IOException {
        this.responseCompleted(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseCompleted(RHTTPResponse response) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responded) {
                this.httpResponse.setStatus(response.getStatusCode());
                for (Map.Entry header : response.getHeaders().entrySet()) {
                    this.httpResponse.setHeader((String)header.getKey(), (String)header.getValue());
                }
                ServletOutputStream output = this.httpResponse.getOutputStream();
                output.write(response.getBody());
                output.flush();
                if (this.continuation != null) {
                    this.continuation.complete();
                    this.continuation = null;
                }
                this.responded = true;
                if (this.logger.isDebugEnabled()) {
                    String eol = System.getProperty("line.separator");
                    this.logger.debug("Request {} responded {}{}{}{}{}", new Object[]{this.request, response, eol, this.request.toLongString(), eol, response.toLongString()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseExpired() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responded) {
                this.httpResponse.sendError(504, "Gateway Time-out");
                this.continuation.complete();
                this.continuation = null;
                this.responded = true;
                this.logger.debug("Request {} expired", new Object[]{this.getRequest()});
            }
        }
    }

    @Override
    public RHTTPRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return this.request.toString();
    }

    private class TimeoutListener
    implements ContinuationListener {
        private TimeoutListener() {
        }

        public void onComplete(Continuation continuation) {
        }

        public void onTimeout(Continuation continuation) {
            ExternalRequest externalRequest = StandardExternalRequest.this.gateway.removeExternalRequest(StandardExternalRequest.this.getRequest().getId());
            if (externalRequest != null) {
                try {
                    StandardExternalRequest.this.responseExpired();
                }
                catch (Exception x) {
                    StandardExternalRequest.this.logger.warn("Request " + StandardExternalRequest.this.getRequest() + " expired but failed", (Throwable)x);
                }
            }
        }
    }
}

