/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.gateway;

import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.gateway.ConnectorServlet;
import org.mortbay.jetty.rhttp.gateway.ExternalServlet;
import org.mortbay.jetty.rhttp.gateway.Gateway;
import org.mortbay.jetty.rhttp.gateway.StandardGateway;
import org.mortbay.jetty.rhttp.gateway.StandardTargetIdRetriever;
import org.mortbay.jetty.rhttp.gateway.TargetIdRetriever;

public class GatewayServer
extends Server {
    public static final String DFT_EXT_PATH = "/gw";
    public static final String DFT_CONNECT_PATH = "/__rhttp";
    private final Logger logger = Log.getLogger((String)((Object)((Object)this)).getClass().toString());
    private final Gateway gateway;
    private final ServletHolder externalServletHolder;
    private final ServletHolder connectorServletHolder;
    private final ServletContextHandler context;

    public GatewayServer() {
        this("", DFT_EXT_PATH, DFT_CONNECT_PATH, new StandardTargetIdRetriever());
    }

    public GatewayServer(String contextPath, String externalServletPath, String gatewayServletPath, TargetIdRetriever targetIdRetriever) {
        HandlerCollection handlers = new HandlerCollection();
        this.setHandler((Handler)handlers);
        this.context = new ServletContextHandler((HandlerContainer)handlers, contextPath, 1);
        this.gateway = this.createGateway();
        ExternalServlet externalServlet = new ExternalServlet(this.gateway, targetIdRetriever);
        this.externalServletHolder = new ServletHolder((Servlet)externalServlet);
        this.context.addServlet(this.externalServletHolder, externalServletPath + "/*");
        this.logger.debug("External servlet mapped to {}/*", new Object[]{externalServletPath});
        ConnectorServlet gatewayServlet = new ConnectorServlet(this.gateway);
        this.connectorServletHolder = new ServletHolder((Servlet)gatewayServlet);
        this.connectorServletHolder.setInitParameter("clientTimeout", "15000");
        this.context.addServlet(this.connectorServletHolder, gatewayServletPath + "/*");
        this.logger.debug("Gateway servlet mapped to {}/*", new Object[]{gatewayServletPath});
    }

    protected Gateway createGateway() {
        StandardGateway gateway = new StandardGateway();
        return gateway;
    }

    public ServletContextHandler getContext() {
        return this.context;
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public ServletHolder getExternalServlet() {
        return this.externalServletHolder;
    }

    public ServletHolder getConnectorServlet() {
        return this.connectorServletHolder;
    }

    public void setTargetIdRetriever(TargetIdRetriever retriever) {
        ((ExternalServlet)this.externalServletHolder.getServletInstance()).setTargetIdRetriever(retriever);
    }

    public TargetIdRetriever getTargetIdRetriever() {
        return ((ExternalServlet)this.externalServletHolder.getServletInstance()).getTargetIdRetriever();
    }
}

