/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.gateway;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.JettyClient;
import org.mortbay.jetty.rhttp.client.RHTTPClient;
import org.mortbay.jetty.rhttp.client.RHTTPListener;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;
import org.mortbay.jetty.rhttp.gateway.GatewayServer;
import org.mortbay.jetty.rhttp.gateway.StandardGateway;
import org.mortbay.jetty.rhttp.gateway.TargetIdRetriever;

public class GatewayProxyServer {
    private static final Logger logger = Log.getLogger((String)GatewayProxyServer.class.toString());

    public static void main(String[] args) throws Exception {
        GatewayServer server = new GatewayServer();
        SelectChannelConnector plainConnector = new SelectChannelConnector();
        plainConnector.setPort(8080);
        server.addConnector((Connector)plainConnector);
        ((StandardGateway)server.getGateway()).setExternalTimeout(180000L);
        ((StandardGateway)server.getGateway()).setGatewayTimeout(20000L);
        server.setTargetIdRetriever(new ProxyTargetIdRetriever());
        server.start();
        HttpClient httpClient = new HttpClient();
        httpClient.setConnectorType(0);
        httpClient.start();
        JettyClient client = new JettyClient(httpClient, new Address("localhost", plainConnector.getPort()), server.getContext().getContextPath() + "/gw", "proxy");
        client.addListener((RHTTPListener)new ProxyListener(httpClient, (RHTTPClient)client));
        client.connect();
        Runtime.getRuntime().addShutdownHook(new Shutdown(server, httpClient, (RHTTPClient)client));
        logger.info("{} started", new Object[]{GatewayProxyServer.class.getSimpleName()});
    }

    public static class ProxyTargetIdRetriever
    implements TargetIdRetriever {
        public String retrieveTargetId(HttpServletRequest httpRequest) {
            return "proxy";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyExchange
    extends ContentExchange {
        private String responseMessage;
        private Map<String, String> responseHeaders = new HashMap<String, String>();
        private ByteArrayOutputStream responseBody = new ByteArrayOutputStream();

        private ProxyExchange() {
            super(true);
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public Map<String, String> getResponseHeaders() {
            return this.responseHeaders;
        }

        public byte[] getResponseBody() {
            return this.responseBody.toByteArray();
        }

        protected void onResponseStatus(Buffer version, int code, Buffer message) throws IOException {
            super.onResponseStatus(version, code, message);
            this.responseMessage = message.toString("UTF-8");
        }

        protected void onResponseHeader(Buffer nameBuffer, Buffer valueBuffer) throws IOException {
            super.onResponseHeader(nameBuffer, valueBuffer);
            String name = nameBuffer.toString("UTF-8");
            String value = valueBuffer.toString("UTF-8");
            if (!name.equalsIgnoreCase("Transfer-Encoding") || !value.equalsIgnoreCase("chunked")) {
                this.responseHeaders.put(name, value);
            }
        }

        protected void onResponseContent(Buffer buffer) throws IOException {
            this.responseBody.write(buffer.asArray());
            super.onResponseContent(buffer);
        }
    }

    private static class ProxyListener
    implements RHTTPListener {
        private final HttpClient httpClient;
        private final RHTTPClient client;

        private ProxyListener(HttpClient httpClient, RHTTPClient client) {
            this.httpClient = httpClient;
            this.client = client;
        }

        public void onRequest(RHTTPRequest request) throws Exception {
            ProxyExchange exchange = new ProxyExchange();
            Address address = Address.from((String)((String)request.getHeaders().get("Host")));
            if (address.getPort() == 0) {
                address = new Address(address.getHost(), 80);
            }
            exchange.setAddress(address);
            exchange.setMethod(request.getMethod());
            exchange.setURI(request.getURI());
            for (Map.Entry header : request.getHeaders().entrySet()) {
                exchange.setRequestHeader((String)header.getKey(), (String)header.getValue());
            }
            exchange.setRequestContent((Buffer)new ByteArrayBuffer(request.getBody()));
            int status = this.syncSend(exchange);
            if (status == 7) {
                int statusCode = exchange.getResponseStatus();
                String statusMessage = exchange.getResponseMessage();
                Map<String, String> responseHeaders = exchange.getResponseHeaders();
                byte[] responseBody = exchange.getResponseBody();
                RHTTPResponse response = new RHTTPResponse(request.getId(), statusCode, statusMessage, responseHeaders, responseBody);
                this.client.deliver(response);
            } else {
                int statusCode = 503;
                String statusMessage = "Gateway error";
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                responseHeaders.put("Connection", "close");
                byte[] responseBody = new byte[]{};
                RHTTPResponse response = new RHTTPResponse(request.getId(), statusCode, statusMessage, responseHeaders, responseBody);
                this.client.deliver(response);
            }
        }

        private int syncSend(ProxyExchange exchange) throws Exception {
            long start = System.nanoTime();
            this.httpClient.send((HttpExchange)exchange);
            int status = exchange.waitForDone();
            long end = System.nanoTime();
            long millis = TimeUnit.NANOSECONDS.toMillis(end - start);
            long micros = TimeUnit.NANOSECONDS.toMicros(end - start - TimeUnit.MILLISECONDS.toNanos(millis));
            logger.debug("Proxied request took {}.{} ms", new Object[]{millis, micros});
            return status;
        }
    }

    private static class Shutdown
    extends Thread {
        private final GatewayServer server;
        private final HttpClient httpClient;
        private final RHTTPClient client;

        public Shutdown(GatewayServer server, HttpClient httpClient, RHTTPClient client) {
            this.server = server;
            this.httpClient = httpClient;
            this.client = client;
        }

        public void run() {
            try {
                this.client.disconnect();
                this.httpClient.stop();
                this.server.stop();
                logger.info("{} stopped", new Object[]{GatewayProxyServer.class.getSimpleName()});
            }
            catch (Exception x) {
                logger.debug("Exception while stopping " + GatewayProxyServer.class.getSimpleName(), (Throwable)x);
            }
        }
    }
}

