/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.gateway.ClientDelegate;
import org.mortbay.jetty.rhttp.gateway.ExternalRequest;
import org.mortbay.jetty.rhttp.gateway.Gateway;
import org.mortbay.jetty.rhttp.gateway.StandardClientDelegate;
import org.mortbay.jetty.rhttp.gateway.StandardExternalRequest;
import org.mortbay.jetty.rhttp.gateway.Utils;

public class StandardGateway
implements Gateway {
    private final Logger logger = Log.getLogger((String)this.getClass().toString());
    private final ConcurrentMap<String, ClientDelegate> clients = new ConcurrentHashMap<String, ClientDelegate>();
    private final ConcurrentMap<Integer, ExternalRequest> requests = new ConcurrentHashMap<Integer, ExternalRequest>();
    private final AtomicInteger requestIds = new AtomicInteger();
    private volatile long gatewayTimeout = 20000L;
    private volatile long externalTimeout = 60000L;

    public long getGatewayTimeout() {
        return this.gatewayTimeout;
    }

    public void setGatewayTimeout(long timeout) {
        this.gatewayTimeout = timeout;
    }

    public long getExternalTimeout() {
        return this.externalTimeout;
    }

    public void setExternalTimeout(long externalTimeout) {
        this.externalTimeout = externalTimeout;
    }

    public ClientDelegate getClientDelegate(String targetId) {
        return (ClientDelegate)this.clients.get(targetId);
    }

    public ClientDelegate newClientDelegate(String targetId) {
        StandardClientDelegate client = new StandardClientDelegate(targetId);
        client.setTimeout(this.getGatewayTimeout());
        return client;
    }

    public ClientDelegate addClientDelegate(String targetId, ClientDelegate client) {
        return this.clients.putIfAbsent(targetId, client);
    }

    public ClientDelegate removeClientDelegate(String targetId) {
        return (ClientDelegate)this.clients.remove(targetId);
    }

    public ExternalRequest newExternalRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        int requestId = this.requestIds.incrementAndGet();
        RHTTPRequest request = this.convertHttpRequest(requestId, httpRequest);
        StandardExternalRequest gatewayRequest = new StandardExternalRequest(request, httpRequest, httpResponse, this);
        gatewayRequest.setTimeout(this.getExternalTimeout());
        return gatewayRequest;
    }

    protected RHTTPRequest convertHttpRequest(int requestId, HttpServletRequest httpRequest) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = httpRequest.getHeader(name);
            headers.put(name, value);
        }
        byte[] body = Utils.read((InputStream)httpRequest.getInputStream());
        return new RHTTPRequest(requestId, httpRequest.getMethod(), httpRequest.getRequestURI(), headers, body);
    }

    public ExternalRequest addExternalRequest(int requestId, ExternalRequest externalRequest) {
        ExternalRequest existing = this.requests.putIfAbsent(requestId, externalRequest);
        if (existing == null) {
            this.logger.debug("Added external request {}/{} - {}", new Object[]{requestId, this.requests.size(), externalRequest});
        }
        return existing;
    }

    public ExternalRequest removeExternalRequest(int requestId) {
        ExternalRequest externalRequest = (ExternalRequest)this.requests.remove(requestId);
        if (externalRequest != null) {
            this.logger.debug("Removed external request {}/{} - {}", new Object[]{requestId, this.requests.size(), externalRequest});
        }
        return externalRequest;
    }
}

