/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EofException;
import org.mortbay.jetty.rhttp.client.AbstractClient;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public class JettyClient
extends AbstractClient {
    private final HttpClient httpClient;
    private final Address gatewayAddress;
    private final String gatewayPath;

    public JettyClient(HttpClient httpClient, Address gatewayAddress, String gatewayPath, String targetId) {
        super(targetId);
        this.httpClient = httpClient;
        this.gatewayAddress = gatewayAddress;
        this.gatewayPath = gatewayPath;
    }

    public JettyClient(HttpClient httpClient, String gatewayURI, String targetId) {
        super(targetId);
        HttpURI uri = new HttpURI(gatewayURI);
        this.httpClient = httpClient;
        this.gatewayAddress = new Address(uri.getHost(), uri.getPort());
        this.gatewayPath = uri.getPath();
    }

    @Override
    public String getHost() {
        return this.gatewayAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.gatewayAddress.getPort();
    }

    @Override
    public String getPath() {
        return this.gatewayPath;
    }

    protected void doStart() throws Exception {
        this.httpClient.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.httpClient.stop();
    }

    @Override
    protected void syncHandshake() throws IOException {
        HandshakeExchange exchange = new HandshakeExchange();
        exchange.setMethod("POST");
        exchange.setAddress(this.gatewayAddress);
        exchange.setURI(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/handshake");
        this.httpClient.send((HttpExchange)exchange);
        this.getLogger().debug("Client {} handshake sent to gateway", new Object[]{this.getTargetId(), null});
        try {
            int exchangeStatus = exchange.waitForDone();
            if (exchangeStatus != 7) {
                throw new IOException("Handshake failed");
            }
            if (exchange.getResponseStatus() != 200) {
                throw new IOException("Handshake failed");
            }
            this.getLogger().debug("Client {} handshake returned from gateway", new Object[]{this.getTargetId(), null});
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            throw this.newIOException(x);
        }
    }

    private IOException newIOException(Throwable x) {
        return (IOException)new IOException().initCause(x);
    }

    @Override
    protected void asyncConnect() {
        try {
            ConnectExchange exchange = new ConnectExchange();
            exchange.setMethod("POST");
            exchange.setAddress(this.gatewayAddress);
            exchange.setURI(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/connect");
            this.httpClient.send((HttpExchange)exchange);
            this.getLogger().debug("Client {} connect sent to gateway", new Object[]{this.getTargetId(), null});
        }
        catch (IOException x) {
            this.getLogger().debug("Could not send exchange", (Throwable)x);
            throw new RuntimeException(x);
        }
    }

    @Override
    protected void syncDisconnect() throws IOException {
        DisconnectExchange exchange = new DisconnectExchange();
        exchange.setMethod("POST");
        exchange.setAddress(this.gatewayAddress);
        exchange.setURI(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/disconnect");
        this.httpClient.send((HttpExchange)exchange);
        this.getLogger().debug("Client {} disconnect sent to gateway", new Object[]{this.getTargetId(), null});
        try {
            int status = exchange.waitForDone();
            if (status != 7) {
                throw new IOException("Disconnect failed");
            }
            if (exchange.getResponseStatus() != 200) {
                throw new IOException("Disconnect failed");
            }
            this.getLogger().debug("Client {} disconnect returned from gateway", new Object[]{this.getTargetId(), null});
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            throw this.newIOException(x);
        }
    }

    @Override
    protected void asyncDeliver(RHTTPResponse response) {
        try {
            DeliverExchange exchange = new DeliverExchange(response);
            exchange.setMethod("POST");
            exchange.setAddress(this.gatewayAddress);
            exchange.setURI(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/deliver");
            exchange.setRequestContent((Buffer)new ByteArrayBuffer(response.getFrameBytes()));
            this.httpClient.send((HttpExchange)exchange);
            this.getLogger().debug("Client {} deliver sent to gateway, response {}", new Object[]{this.getTargetId(), response});
        }
        catch (IOException x) {
            this.getLogger().debug("Could not send exchange", (Throwable)x);
            throw new RuntimeException(x);
        }
    }

    protected class DeliverExchange
    extends ContentExchange {
        private final RHTTPResponse response;

        protected DeliverExchange(RHTTPResponse response) {
            super(true);
            this.response = response;
        }

        protected void onResponseComplete() throws IOException {
            int responseStatus = this.getResponseStatus();
            if (responseStatus == 401) {
                JettyClient.this.notifyConnectRequired();
            } else if (responseStatus != 200) {
                JettyClient.this.notifyDeliverException(this.response);
            }
        }

        protected void onException(Throwable x) {
            JettyClient.this.getLogger().debug(x);
            JettyClient.this.notifyDeliverException(this.response);
        }

        protected void onConnectionFailed(Throwable x) {
            JettyClient.this.getLogger().debug(x);
        }
    }

    protected class DisconnectExchange
    extends ContentExchange {
        protected DisconnectExchange() {
            super(true);
        }
    }

    protected class ConnectExchange
    extends ContentExchange {
        private final ByteArrayOutputStream content;

        protected ConnectExchange() {
            super(true);
            this.content = new ByteArrayOutputStream();
        }

        protected void onResponseContent(Buffer buffer) throws IOException {
            buffer.writeTo((OutputStream)this.content);
        }

        protected void onResponseComplete() {
            int responseStatus = this.getResponseStatus();
            if (responseStatus == 200) {
                try {
                    JettyClient.this.connectComplete(this.content.toByteArray());
                }
                catch (IOException x) {
                    this.onException(x);
                }
            } else if (responseStatus == 401) {
                JettyClient.this.notifyConnectRequired();
            } else {
                JettyClient.this.notifyConnectException();
            }
        }

        protected void onException(Throwable x) {
            JettyClient.this.getLogger().debug(x);
            if (x instanceof EofException || x instanceof EOFException) {
                JettyClient.this.notifyConnectClosed();
            } else {
                JettyClient.this.notifyConnectException();
            }
        }

        protected void onConnectionFailed(Throwable x) {
            JettyClient.this.getLogger().debug(x);
        }
    }

    protected class HandshakeExchange
    extends ContentExchange {
        protected HandshakeExchange() {
            super(true);
        }

        protected void onConnectionFailed(Throwable x) {
            JettyClient.this.getLogger().warn(x.toString(), new Object[0]);
            JettyClient.this.getLogger().debug(x);
        }
    }
}

