/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.mortbay.jetty.rhttp.client.ApacheClient;
import org.mortbay.jetty.rhttp.client.ClientListener;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public class RetryingApacheClient
extends ApacheClient {
    public RetryingApacheClient(HttpClient httpClient, String gatewayURI, String targetId) {
        super(httpClient, gatewayURI, targetId);
        this.addClientListener(new RetryClientListener());
    }

    @Override
    protected void syncHandshake() throws IOException {
        while (true) {
            try {
                super.syncHandshake();
                break;
            }
            catch (IOException x) {
                this.getLogger().debug("Handshake failed, backing off and retrying", new Object[0]);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException xx) {
                    throw (IOException)new IOException().initCause(xx);
                }
            }
        }
    }

    private class RetryClientListener
    implements ClientListener {
        private RetryClientListener() {
        }

        @Override
        public void connectRequired() {
            RetryingApacheClient.this.getLogger().debug("Connect requested by server", new Object[0]);
            try {
                RetryingApacheClient.this.connect();
            }
            catch (IOException x) {
                RetryingApacheClient.this.getLogger().debug("Connect failed after server required connect, giving up", new Object[0]);
            }
        }

        @Override
        public void connectClosed() {
            this.connectException();
        }

        @Override
        public void connectException() {
            RetryingApacheClient.this.getLogger().debug("Connect failed, backing off and retrying", new Object[0]);
            try {
                Thread.sleep(1000L);
                RetryingApacheClient.this.asyncConnect();
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void deliverException(RHTTPResponse response) {
            RetryingApacheClient.this.getLogger().debug("Deliver failed, backing off and retrying", new Object[0]);
            try {
                Thread.sleep(1000L);
                RetryingApacheClient.this.asyncDeliver(response);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

