/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.mortbay.jetty.rhttp.client.AbstractClient;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public class ApacheClient
extends AbstractClient {
    private final HttpClient httpClient;
    private final String gatewayPath;

    public ApacheClient(HttpClient httpClient, String gatewayPath, String targetId) {
        super(targetId);
        this.httpClient = httpClient;
        this.gatewayPath = gatewayPath;
    }

    @Override
    public String getHost() {
        return ((HttpHost)this.httpClient.getParams().getParameter("http.default-host")).getHostName();
    }

    @Override
    public int getPort() {
        return ((HttpHost)this.httpClient.getParams().getParameter("http.default-host")).getPort();
    }

    @Override
    public String getPath() {
        return this.gatewayPath;
    }

    @Override
    protected void syncHandshake() throws IOException {
        HttpPost handshake = new HttpPost(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/handshake");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)handshake);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
        if (statusCode != 200) {
            throw new IOException("Handshake failed");
        }
        this.getLogger().debug("Client {} handshake returned from gateway", new Object[]{this.getTargetId(), null});
    }

    @Override
    protected void asyncConnect() {
        new Thread(){

            @Override
            public void run() {
                try {
                    HttpPost connect = new HttpPost(ApacheClient.this.gatewayPath + "/" + ApacheClient.this.urlEncode(ApacheClient.this.getTargetId()) + "/connect");
                    ApacheClient.this.getLogger().debug("Client {} connect sent to gateway", new Object[]{ApacheClient.this.getTargetId(), null});
                    HttpResponse response = ApacheClient.this.httpClient.execute((HttpUriRequest)connect);
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    byte[] responseContent = EntityUtils.toByteArray((HttpEntity)entity);
                    if (statusCode == 200) {
                        ApacheClient.this.connectComplete(responseContent);
                    } else if (statusCode == 401) {
                        ApacheClient.this.notifyConnectRequired();
                    } else {
                        ApacheClient.this.notifyConnectException();
                    }
                }
                catch (NoHttpResponseException x) {
                    ApacheClient.this.notifyConnectClosed();
                }
                catch (IOException x) {
                    ApacheClient.this.getLogger().debug("", (Throwable)x);
                    ApacheClient.this.notifyConnectException();
                }
            }
        }.start();
    }

    @Override
    protected void syncDisconnect() throws IOException {
        HttpPost disconnect = new HttpPost(this.gatewayPath + "/" + this.urlEncode(this.getTargetId()) + "/disconnect");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)disconnect);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
        if (statusCode != 200) {
            throw new IOException("Disconnect failed");
        }
        this.getLogger().debug("Client {} disconnect returned from gateway", new Object[]{this.getTargetId(), null});
    }

    @Override
    protected void asyncDeliver(final RHTTPResponse response) {
        new Thread(){

            @Override
            public void run() {
                try {
                    HttpPost deliver = new HttpPost(ApacheClient.this.gatewayPath + "/" + ApacheClient.this.urlEncode(ApacheClient.this.getTargetId()) + "/deliver");
                    deliver.setEntity((HttpEntity)new ByteArrayEntity(response.getFrameBytes()));
                    ApacheClient.this.getLogger().debug("Client {} deliver sent to gateway, response {}", new Object[]{ApacheClient.this.getTargetId(), response});
                    HttpResponse httpResponse = ApacheClient.this.httpClient.execute((HttpUriRequest)deliver);
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = httpResponse.getEntity();
                    if (entity != null) {
                        entity.consumeContent();
                    }
                    if (statusCode == 401) {
                        ApacheClient.this.notifyConnectRequired();
                    } else if (statusCode != 200) {
                        ApacheClient.this.notifyDeliverException(response);
                    }
                }
                catch (IOException x) {
                    ApacheClient.this.getLogger().debug("", (Throwable)x);
                    ApacheClient.this.notifyDeliverException(response);
                }
            }
        }.start();
    }
}

