/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RHTTPRequest {
    private static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();
    private final int id;
    private final byte[] requestBytes;
    private final byte[] frameBytes;
    private volatile String method;
    private volatile String uri;
    private volatile Map<String, String> headers;
    private volatile byte[] body;

    public static List<RHTTPRequest> fromFrameBytes(byte[] bytes) {
        int length;
        ArrayList<RHTTPRequest> result = new ArrayList<RHTTPRequest>();
        for (int start = 0; start < bytes.length; start += length) {
            int end = start;
            while (bytes[end] != 32) {
                ++end;
            }
            int requestId = Integer.parseInt(new String(bytes, start, end - start));
            start = end + 1;
            while (bytes[end] != 10) {
                ++end;
            }
            length = Integer.parseInt(new String(bytes, start, end - start - 1));
            start = end + 1;
            byte[] requestBytes = new byte[length];
            System.arraycopy(bytes, start, requestBytes, 0, length);
            RHTTPRequest request = RHTTPRequest.fromRequestBytes(requestId, requestBytes);
            result.add(request);
        }
        return result;
    }

    public static RHTTPRequest fromRequestBytes(int requestId, byte[] requestBytes) {
        return new RHTTPRequest(requestId, requestBytes);
    }

    public RHTTPRequest(int id, String method, String uri, Map<String, String> headers, byte[] body) {
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
        this.requestBytes = this.toRequestBytes();
        this.frameBytes = this.toFrameBytes(this.requestBytes);
    }

    private RHTTPRequest(int id, byte[] requestBytes) {
        this.id = id;
        this.requestBytes = requestBytes;
        this.frameBytes = this.toFrameBytes(requestBytes);
    }

    private void initialize() {
        try {
            final ByteArrayOutputStream body = new ByteArrayOutputStream();
            HttpParser parser = new HttpParser((Buffer)new ByteArrayBuffer(this.requestBytes), new HttpParser.EventHandler(){

                public void startRequest(Buffer method, Buffer uri, Buffer httpVersion) throws IOException {
                    RHTTPRequest.this.method = method.toString("UTF-8");
                    RHTTPRequest.this.uri = uri.toString("UTF-8");
                    RHTTPRequest.this.headers = new LinkedHashMap();
                }

                public void startResponse(Buffer httpVersion, int statusCode, Buffer statusMessage) throws IOException {
                }

                public void parsedHeader(Buffer name, Buffer value) throws IOException {
                    RHTTPRequest.this.headers.put(name.toString("UTF-8"), value.toString("UTF-8"));
                }

                public void content(Buffer content) throws IOException {
                    content.writeTo((OutputStream)body);
                }
            });
            parser.parse();
            this.body = body.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    public int getId() {
        return this.id;
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    public byte[] getFrameBytes() {
        return this.frameBytes;
    }

    public String getMethod() {
        if (this.method == null) {
            this.initialize();
        }
        return this.method;
    }

    public String getURI() {
        if (this.uri == null) {
            this.initialize();
        }
        return this.uri;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.initialize();
        }
        return this.headers;
    }

    public byte[] getBody() {
        if (this.body == null) {
            this.initialize();
        }
        return this.body;
    }

    private byte[] toRequestBytes() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(this.method.getBytes("UTF-8"));
            bytes.write(32);
            bytes.write(this.uri.getBytes("UTF-8"));
            bytes.write(32);
            bytes.write("HTTP/1.1".getBytes("UTF-8"));
            bytes.write(CRLF_BYTES);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                bytes.write(entry.getKey().getBytes("UTF-8"));
                bytes.write(58);
                bytes.write(32);
                bytes.write(entry.getValue().getBytes("UTF-8"));
                bytes.write(CRLF_BYTES);
            }
            bytes.write(CRLF_BYTES);
            bytes.write(this.body);
            bytes.close();
            return bytes.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    private byte[] toFrameBytes(byte[] requestBytes) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(String.valueOf(this.id).getBytes("UTF-8"));
            bytes.write(32);
            bytes.write(String.valueOf(requestBytes.length).getBytes("UTF-8"));
            bytes.write(CRLF_BYTES);
            bytes.write(requestBytes);
            bytes.close();
            return bytes.toByteArray();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" ");
        builder.append(this.method).append(" ");
        builder.append(this.uri).append(" ");
        builder.append(this.requestBytes.length).append("/");
        builder.append(this.frameBytes.length);
        return builder.toString();
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(" ");
        builder.append(this.getMethod()).append(" ");
        builder.append(this.getURI()).append(CRLF);
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            builder.append(header.getKey()).append(": ").append(header.getValue()).append(CRLF);
        }
        builder.append(this.getBody().length).append(" body bytes").append(CRLF);
        return builder.toString();
    }
}

