/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */
package javax.servlet.jsp;

/**
 * A generic exception known to the JSP engine; uncaught
 * JspExceptions will result in an invocation of the errorpage
 * machinery.
 */

public class JspException extends Exception {

    /**
     * Construct a JspException.
     */
    public JspException() {
    }


    /**
     * Constructs a new JSP exception with the
     * specified message. The message can be written 
     * to the server log and/or displayed for the user. 
     *
     * @param msg 		a <code>String</code> 
     *				specifying the text of 
     *				the exception message
     *
     */
    public JspException(String msg) {
	super(msg);
    }


    /**
     * Constructs a new <code>JspException</code> with the specified detail
     * message and cause.
     *
     * The cause is saved for later retrieval by the
     * {@link #getCause()} and {@link #getRootCause()} methods.
     *
     * @see java.lang.Exception#Exception(String, Throwable)
     */
    public JspException(String message, Throwable cause) {
	super(message, cause);
    }


    /**
     * Constructs a new <code>JspException</code> with the specified cause.
     *
     * The cause is saved for later retrieval by the
     * {@link #getCause()} and {@link #getRootCause()} methods.
     *
     * @see java.lang.Exception#Exception(Throwable)
     */
    public JspException(Throwable cause) {
	super(cause);
    }

    
    /**
     * Returns the exception that caused this JSP exception.
     *
     * @return			the <code>Throwable</code> 
     *				that caused this JSP exception
     *
     * @deprecated As of JSP 2.1, replaced by {@link #getCause()}
     */
    
    public Throwable getRootCause() {
	return getCause();
    }
}
