/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mortbay.jetty.webapp.verifier.AbstractRule;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ServletSupportLevelRule
extends AbstractRule {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private String supportedVersion = "2.5";
    private String fileSep = System.getProperty("file.separator", "/");
    private List<ServletId> dtdPublicIds = new ArrayList<ServletId>();
    private List<ServletId> dtdSystemIds = new ArrayList<ServletId>();
    private List<ServletId> nsIds = new ArrayList<ServletId>();
    private List<ServletId> schemaIds = new ArrayList<ServletId>();
    private String[] validVersions = new String[]{"2.5", "2.4", "2.3", "2.2"};

    public ServletSupportLevelRule() {
        this.schemaIds.add(new ServletId("2.5", "Schema", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd"));
        this.nsIds.add(new ServletId("2.5", "XML Namespace", "http://java.sun.com/xml/ns/javaee"));
        this.schemaIds.add(new ServletId("2.4", "Schema", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd"));
        this.nsIds.add(new ServletId("2.4", "XML Namespace", "http://java.sun.com/xml/ns/j2ee"));
        this.dtdPublicIds.add(new ServletId("2.3", "DOCTYPE Public ID", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"));
        this.dtdSystemIds.add(new ServletId("2.3", "DOCTYPE System ID", "http://java.sun.com/dtd/web-app_2_3.dtd"));
        this.dtdPublicIds.add(new ServletId("2.2", "DOCTYPE Public ID", "-//Sun Microsystems, Inc.//DTD WebApplication 2.2//EN"));
        this.dtdSystemIds.add(new ServletId("2.2", "DOCTYPE System ID", "http://java.sun.com/j2ee/dtds/web-app_2.2.dtd"));
    }

    @Override
    public String getDescription() {
        return "Ensure webapp works within supported servlet spec";
    }

    @Override
    public String getName() {
        return "servlet-support-level";
    }

    public String getSupportedVersion() {
        return this.supportedVersion;
    }

    public void setSupportedVersion(String supportedLevel) {
        this.supportedVersion = supportedLevel;
    }

    @Override
    public void visitWebappStart(String path, File dir) {
        super.visitWebappStart(path, dir);
        File webXmlFile = new File(dir, "WEB-INF/web.xml".replaceAll("/", this.fileSep));
        String webxmlpath = this.getWebappRelativePath(webXmlFile);
        if (!webXmlFile.exists()) {
            this.error(webxmlpath, "web.xml does not exist");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(webXmlFile);
            List<ServletId> detectedIds = this.collectServletIds(webxmlpath, doc);
            TreeSet<String> versions = new TreeSet<String>();
            for (ServletId id : detectedIds) {
                versions.add(id.version);
            }
            if (versions.size() > 1) {
                String msg = String.format("Found %d versions defined [%s], expected 1", versions.size(), this.join(versions, ", "));
                this.error(webxmlpath, msg);
                for (ServletId id : detectedIds) {
                    this.reportConflicting(webxmlpath, id, detectedIds);
                }
            }
            this.reportOverVersion(webxmlpath, detectedIds);
        }
        catch (ParserConfigurationException e) {
            this.exception(webxmlpath, "[internal] Unable to establish XML parser", e);
        }
        catch (SAXException e) {
            this.exception(webxmlpath, "Unable to parse web.xml", e);
        }
        catch (IOException e) {
            this.exception(webxmlpath, "Unable to parse web.xml", e);
        }
    }

    private void reportOverVersion(String webxmlpath, List<ServletId> detectedIds) {
        double supportedVer = Double.parseDouble(this.supportedVersion);
        for (ServletId id : detectedIds) {
            try {
                double detectedVersion = Double.parseDouble(id.version);
                if (!(detectedVersion > supportedVer)) continue;
                String msg = String.format("Specified servlet version %s of %s is over the configured supported servlet version %s", id.version, id.type, this.supportedVersion);
                this.error(webxmlpath, msg);
            }
            catch (NumberFormatException e) {
                this.error(webxmlpath, String.format("Unable to parse version [%s] of %s, not a double", id.version, id.type));
            }
        }
    }

    private void reportConflicting(String webxmlpath, ServletId mainId, List<ServletId> otherIds) {
        for (ServletId id : otherIds) {
            if (id.version.equals(mainId.version)) continue;
            String msg = String.format("version %s of %s conflicts with version %s of %s", mainId.version, mainId.type, id.version, id.type);
            this.error(webxmlpath, msg);
        }
    }

    private String join(Collection<?> coll, String delim) {
        StringBuffer msg = new StringBuffer();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            msg.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            msg.append(delim);
        }
        return msg.toString();
    }

    private List<ServletId> collectServletIds(String webxmlpath, Document doc) {
        Element root;
        ArrayList<ServletId> ids = new ArrayList<ServletId>();
        DocumentType doctype = doc.getDoctype();
        if (doctype != null) {
            if ("web-app".equals(doctype.getName())) {
                boolean valid = false;
                for (ServletId id : this.dtdPublicIds) {
                    if (!id.name.equals(doctype.getPublicId())) continue;
                    ids.add(id);
                    valid = true;
                }
                if (!valid) {
                    this.error(webxmlpath, "Invalid DOCTYPE public ID: " + doctype.getPublicId());
                }
                valid = false;
                for (ServletId id : this.dtdSystemIds) {
                    if (!id.name.equals(doctype.getSystemId())) continue;
                    ids.add(id);
                    valid = true;
                }
                if (!valid) {
                    this.error(webxmlpath, "Invalid DOCTYPE system ID: " + doctype.getSystemId());
                }
            } else {
                this.error(webxmlpath, "Invalid DOCTYPE detected, expected 'web-app', but found '" + doctype.getName() + "' instaed.");
            }
        }
        if ("web-app".equals((root = doc.getDocumentElement()).getTagName())) {
            String actualVersion;
            String actualSchema;
            String actualXsi;
            String actualXmlNs = root.getAttribute("xmlns");
            if (this.hasAnyValue(actualXmlNs, actualXsi = root.getAttribute("xmlns:xsi"), actualSchema = root.getAttribute("xsi:schemaLocation"), actualVersion = root.getAttribute("version"))) {
                String msg;
                boolean valid;
                if (actualXmlNs == null || actualXmlNs == "") {
                    this.error(webxmlpath, "Attribute <web-app xmlns=\"\"> must exist with a valid value");
                } else {
                    valid = false;
                    for (ServletId id : this.nsIds) {
                        if (!id.name.equals(actualXmlNs)) continue;
                        ids.add(id);
                        valid = true;
                    }
                    if (!valid) {
                        msg = String.format("Invalid xmlns value for <web-app xmlns=\"%s\">", actualXmlNs);
                        this.error(webxmlpath, msg);
                    }
                }
                if (actualXsi == null || actualXsi == "") {
                    this.error(webxmlpath, "Attribute <web-app xmlns:xsi=\"\"> must exist with a valid value");
                } else if (!XSI_NS.equals(actualXsi)) {
                    String msg2 = String.format("Attribute mismatch expecting <web-app xmlns:xsi=\"%s\"> but found <web-app xmlns:xsi=\"%s\">", XSI_NS, actualXsi);
                    this.error(webxmlpath, msg2);
                }
                if (actualSchema == null || actualSchema == "") {
                    this.error(webxmlpath, "Attribute <web-app xsi:schemaLocation=\"\"> must exist with a valid value");
                } else {
                    valid = false;
                    for (ServletId id : this.schemaIds) {
                        if (!id.name.equals(actualSchema)) continue;
                        ids.add(id);
                        valid = true;
                    }
                    if (!valid) {
                        msg = String.format("Invalid schemaLocation value <web-app xsi:schemaLocation=\"%s\">", actualSchema);
                        this.error(webxmlpath, msg);
                    }
                }
                if (actualVersion == null || actualVersion == "") {
                    this.error(webxmlpath, "Attribute <web-app version=\"\"> must exist with a valid value");
                } else {
                    valid = false;
                    for (String version : this.validVersions) {
                        if (!version.equals(actualVersion)) continue;
                        ids.add(new ServletId(version, "version attribute", null));
                        valid = true;
                    }
                    if (!valid) {
                        msg = String.format("Invalid version value <web-app version=\"%s\">", actualVersion);
                        this.error(webxmlpath, msg);
                    }
                }
            }
        } else {
            this.error(webxmlpath, "Invalid web.xml, root element expectd to be <web-app>, but was <" + root.getTagName() + ">");
        }
        return ids;
    }

    private boolean hasAnyValue(String ... values) {
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            return true;
        }
        return false;
    }

    class ServletId {
        String version;
        String name;
        String type;

        public ServletId(String version, String type, String name) {
            this.version = version;
            this.type = type;
            this.name = name;
        }
    }
}

