/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.jetty.webapp.verifier.AbstractRule;

public class RequiredContentsRule
extends AbstractRule {
    private List<String> _paths = new ArrayList<String>();

    public void addPath(String path) {
        this._paths.add(path);
    }

    @Override
    public String getDescription() {
        return "Ensures that requred content is present";
    }

    @Override
    public String getName() {
        return "required-content";
    }

    @Override
    public void visitDirectoryEnd(String path, File dir) {
        if (path.equals("")) {
            File root = new File(dir, path);
            for (String expectedPath : this._paths) {
                File file = new File(root, expectedPath);
                if (file.exists()) continue;
                this.error(this.getWebappRelativePath(file), "Required content not found");
            }
        }
    }
}

