/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractArchiveScanningRule;

public class NoSourceControlRule
extends AbstractArchiveScanningRule {
    private static List<ScmName> scmDirNames = new ArrayList<ScmName>();
    private static List<ScmName> scmFileNames = new ArrayList<ScmName>();

    public NoSourceControlRule() {
        scmDirNames.add(new ScmName("Subversion", ".svn"));
        scmDirNames.add(new ScmName("Subversion", "_svn"));
        scmDirNames.add(new ScmName("CVS", "CVS"));
        scmFileNames.add(new ScmName("CVS", ".cvsignore"));
        scmDirNames.add(new ScmName("Git", ".git"));
        scmFileNames.add(new ScmName("Git", ".gitignore"));
        scmDirNames.add(new ScmName("RCS", "RCS"));
        scmDirNames.add(new ScmName("SCCS", "SCCS"));
        scmFileNames.add(new ScmName("Visual SourceSafe", "vssver.scc"));
        scmDirNames.add(new ScmName("Arch", ".arch-ids"));
        scmDirNames.add(new ScmName("Bazaar", ".bzr"));
        scmFileNames.add(new ScmName("SurroundSCM", ".MySCMServerInfo"));
        scmDirNames.add(new ScmName("Mercurial", ".hg"));
        scmDirNames.add(new ScmName("BitKeeper", "BitKeeper"));
        scmDirNames.add(new ScmName("BitKeeper", "ChangeSet"));
        scmDirNames.add(new ScmName("Darcs", "_darcs"));
        scmDirNames.add(new ScmName("Darcs", ".darcsrepo"));
        scmFileNames.add(new ScmName("Darcs", ".darcs-temp-mail"));
    }

    @Override
    public String getDescription() {
        return "Prevent inclusion of source control files in webapp";
    }

    @Override
    public String getName() {
        return "no-source-control";
    }

    @Override
    public void visitDirectoryStart(String path, File dir) {
        for (ScmName scmName : scmDirNames) {
            if (!dir.getName().equalsIgnoreCase(scmName.name)) continue;
            this.error(path, scmName.scm + " Source Control directories are not allowed");
        }
    }

    @Override
    public void visitFile(String path, File dir, File file) {
        for (ScmName scmName : scmFileNames) {
            if (!file.getName().equalsIgnoreCase(scmName.name)) continue;
            this.error(path, scmName.scm + " Source Control file are not allowed");
        }
    }

    @Override
    public void visitArchiveResource(String path, ZipFile zip, ZipEntry entry) {
        String basename = this.toBaseName(entry);
        if (entry.isDirectory()) {
            for (ScmName scmName : scmDirNames) {
                if (!basename.equalsIgnoreCase(scmName.name)) continue;
                this.error(path, scmName.scm + " Source Control directories are not allowed");
            }
        } else {
            for (ScmName scmName : scmFileNames) {
                if (!basename.equalsIgnoreCase(scmName.name)) continue;
                this.error(path, scmName.scm + " Source Control file are not allowed");
            }
        }
    }

    private String toBaseName(ZipEntry entry) {
        int idx;
        String name = entry.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf(47)) >= 0) {
            return name.substring(idx + 1);
        }
        return name;
    }

    class ScmName {
        String scm;
        String name;

        public ScmName(String scm, String name) {
            this.scm = scm;
            this.name = name;
        }
    }
}

