/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractArchiveScanningRule;

public class ForbiddenClassesRule
extends AbstractArchiveScanningRule {
    private Map<String, Pattern> classPatterns = new HashMap<String, Pattern>();

    public void addClassPattern(String classPattern) {
        StringBuffer regex = new StringBuffer();
        for (char c : classPattern.toCharArray()) {
            if (c == '.') {
                regex.append("\\.");
                continue;
            }
            if (c == '*') {
                regex.append(".*");
                continue;
            }
            regex.append(c);
        }
        this.classPatterns.put(classPattern, Pattern.compile(regex.toString()));
    }

    @Override
    public String getDescription() {
        return "Ensures that forbidden packages are not present in the war file";
    }

    @Override
    public String getName() {
        return "forbidden-class";
    }

    private void validateClassname(String path, String className) {
        for (Map.Entry<String, Pattern> pattern : this.classPatterns.entrySet()) {
            if (!pattern.getValue().matcher(className).matches()) continue;
            this.error(path, "Class forbidden by pattern: " + pattern.getKey());
        }
    }

    @Override
    public void visitWebInfClass(String path, String className, File classFile) {
        this.validateClassname(path, className);
    }

    @Override
    public void visitArchiveClass(String path, String className, ZipFile archive, ZipEntry archiveEntry) {
        this.validateClassname(path, className);
    }
}

