/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.deployman;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.verifier.RuleSet;
import org.mortbay.jetty.webapp.verifier.Severity;
import org.mortbay.jetty.webapp.verifier.Violation;
import org.mortbay.jetty.webapp.verifier.WebappVerifier;

public class WebappVerifierBinding
implements AppLifeCycle.Binding {
    private static final Logger LOG = Log.getLogger(WebappVerifierBinding.class);
    private String rulesetPath;

    public String getRulesetPath() {
        return this.rulesetPath;
    }

    public void setRulesetPath(String rulesetPath) {
        this.rulesetPath = rulesetPath;
    }

    public String[] getBindingTargets() {
        return new String[]{"deploying"};
    }

    public void processBinding(Node node, App app) throws Exception {
        ContextHandler context = app.getContextHandler();
        if (!(context instanceof WebAppContext)) {
            LOG.info("Webapp Verifier - " + app.getContextHandler().getClass().getName() + " is not an instance of " + WebAppContext.class.getName(), new Object[0]);
            return;
        }
        WebAppContext wac = (WebAppContext)context;
        URI warURI = new URI(wac.getWar());
        File rulesetFile = new File(this.rulesetPath);
        RuleSet ruleset = RuleSet.load(rulesetFile);
        WebappVerifier verifier = ruleset.createWebappVerifier(warURI);
        verifier.visitAll();
        Collection<Violation> violations = verifier.getViolations();
        if (violations.size() <= 0) {
            LOG.info("Webapp Verifier - All Rules Passed - No Violations", new Object[0]);
            return;
        }
        boolean haltWebapp = false;
        LOG.info("Webapp Verifier Found " + violations.size() + " violations.", new Object[0]);
        for (Violation violation : violations) {
            if (violation.getSeverity() == Severity.ERROR) {
                haltWebapp = true;
            }
            LOG.info(violation.toString(), new Object[0]);
        }
        if (haltWebapp) {
            throw new IllegalStateException("Webapp Failed Webapp Verification");
        }
    }
}

