/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import java.io.File;
import org.mortbay.jetty.webapp.verifier.RuleSet;
import org.mortbay.jetty.webapp.verifier.Violation;
import org.mortbay.jetty.webapp.verifier.WebappVerifier;

public class WebappVerifierCLI {
    private static final String ARG_WEBARCHIVE = "webarchive";
    private static final String ARG_RULESET = "ruleset";

    public static void main(String[] args) {
        File webarchiveFile = null;
        File rulesetFile = null;
        for (String arg : args) {
            if (arg.startsWith("--webarchive=")) {
                webarchiveFile = new File(arg.substring(3 + ARG_WEBARCHIVE.length()));
                continue;
            }
            if (!arg.startsWith("--ruleset=")) continue;
            rulesetFile = new File(arg.substring(3 + ARG_RULESET.length()));
        }
        boolean argsValid = true;
        if (webarchiveFile == null) {
            argsValid = false;
            System.err.println("ERROR: no webarchive provided.");
        } else if (!webarchiveFile.exists()) {
            argsValid = false;
            System.err.println("ERROR: File [webarchive] Not Found: " + webarchiveFile.getAbsolutePath());
        }
        if (rulesetFile == null) {
            argsValid = false;
            System.err.println("ERROR: no ruleset provided.");
        } else if (!rulesetFile.exists()) {
            argsValid = false;
            System.err.println("ERROR: File [ruleset] Not Found: " + rulesetFile.getAbsolutePath());
        }
        if (!argsValid) {
            System.out.println("Usage: java -jar jetty-webapp-verifier.jar --webarchive=<path_to_archive> --ruleset=<path_to_ruleset>");
            System.exit(-1);
        }
        try {
            System.out.println("Loading Ruleset: " + rulesetFile);
            RuleSet ruleset = RuleSet.load(rulesetFile);
            System.out.println("Loading Web Archive: " + webarchiveFile);
            WebappVerifier verifier = ruleset.createWebappVerifier(webarchiveFile.toURI());
            System.out.println("Analyzing ...");
            verifier.visitAll();
            for (Violation violation : verifier.getViolations()) {
                System.out.println(violation);
            }
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

