/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.mortbay.jetty.webapp.verifier.Rule;
import org.mortbay.jetty.webapp.verifier.Severity;
import org.mortbay.jetty.webapp.verifier.Violation;
import org.mortbay.jetty.webapp.verifier.ViolationListener;

public class WebappVerifier
implements ViolationListener {
    private URI _webappURI;
    private File _webappDir;
    private File _workdir;
    private List<Rule> _rules;
    private Map<String, List<Violation>> _violations;

    public WebappVerifier(URI webappURI) {
        this._webappURI = webappURI;
        this._workdir = new File(System.getProperty("java.io.tmpdir"), "jetty-webapp-verifier");
        this._rules = new ArrayList<Rule>();
        this._violations = new HashMap<String, List<Violation>>();
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
        try {
            rule.setViolationListener(this);
            rule.initialize();
        }
        catch (Throwable t) {
            String msg = String.format("Unable to add rule [%s]: %s", rule.getName(), t.getMessage());
            this.reportException("", msg, rule, t);
        }
    }

    private String cleanFilename(URI uri) {
        String destname = uri.getPath();
        int idx = destname.lastIndexOf(47);
        if (idx > 0) {
            destname = destname.substring(idx);
        }
        if ((destname = destname.trim().toLowerCase()).length() <= 0) {
            destname = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss").format(new Date());
        }
        char[] cleaned = new char[destname.length()];
        for (int i = 0; i < destname.length(); ++i) {
            char c = destname.charAt(i);
            cleaned[i] = c == '|' || c == '/' || c == '\\' || c == '*' || c == '?' || c == ':' || c == '#' ? 95 : c;
        }
        destname = new String(cleaned);
        if (!destname.endsWith(".war")) {
            destname = destname + ".war";
        }
        return destname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File download(URI uri) throws MalformedURLException, IOException {
        if (!this._workdir.exists()) {
            this._workdir.mkdirs();
        }
        File destfile = new File(this._workdir, this.cleanFilename(uri));
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = Resource.newResource((String)uri.toString()).getInputStream();
            out = new FileOutputStream(destfile);
            IO.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close(out);
            throw throwable;
        }
        IO.close((InputStream)in);
        IO.close((OutputStream)out);
        return destfile;
    }

    private File establishLocalWebappDir() throws URISyntaxException, IOException {
        if ("file".equals(this._webappURI.getScheme())) {
            File path = new File(this._webappURI);
            if (path.isDirectory()) {
                return path;
            }
            return this.unpack(path);
        }
        File downloadedFile = this.download(this._webappURI);
        return this.unpack(downloadedFile);
    }

    public List<Rule> getRules() {
        return this._rules;
    }

    public Collection<Violation> getViolations() {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (List<Violation> pathviol : this._violations.values()) {
            violations.addAll(pathviol);
        }
        return violations;
    }

    public File getWebappDir() {
        return this._webappDir;
    }

    private String getWebappRelativePath(File dir) {
        return this._webappDir.toURI().relativize(dir.toURI()).toASCIIString();
    }

    public File getWorkDir() {
        return this._workdir;
    }

    private boolean isValidWebapp(File path) {
        File webXml = new File(path, "WEB-INF" + File.separator + "web.xml");
        if (!webXml.exists()) {
            this.reportViolation(Severity.ERROR, "", "Missing WEB-INF/web.xml");
            return false;
        }
        if (!webXml.isFile()) {
            this.reportViolation(Severity.ERROR, "", "The WEB-INF/web.xml is not a File");
            return false;
        }
        return true;
    }

    private void reportException(String path, String detail, Rule rule, Throwable t) {
        Violation viol = new Violation(Severity.ERROR, path, detail, t);
        viol.setVerifierInfo(rule);
        this.reportViolation(viol);
    }

    public void reportViolation(Severity error, String path, String detail) {
        this.reportViolation(new Violation(error, path, detail));
    }

    @Override
    public void reportViolation(Violation violation) {
        List<Violation> pathviol = this._violations.get(violation.getPath());
        if (pathviol == null) {
            pathviol = new ArrayList<Violation>();
        }
        pathviol.add(violation);
        this._violations.put(violation.getPath(), pathviol);
    }

    public void setRules(Collection<Rule> rules) {
        this._rules.clear();
        for (Rule verifier : rules) {
            this.addRule(verifier);
        }
    }

    public void setWorkDir(File workDir) {
        this._workdir = workDir;
    }

    private File unpack(File path) throws URISyntaxException, IOException {
        String destname = path.getName().substring(0, path.getName().length() - 4);
        File destDir = new File(this._workdir, destname);
        URI warURI = new URI("jar", path.toURI() + "!/", null);
        JarResource warResource = (JarResource)Resource.newResource((URI)warURI);
        warResource.copyTo(destDir);
        return destDir;
    }

    public void visitAll() {
        try {
            this._webappDir = this.establishLocalWebappDir();
            for (Rule rule : this._rules) {
                rule.visitWebappStart("", this._webappDir);
            }
            if (this.isValidWebapp(this._webappDir)) {
                this.visitContents();
                this.visitWebInfClasses();
                this.visitWebInfLib();
            }
            for (Rule rule : this._rules) {
                rule.visitWebappEnd("", this._webappDir);
            }
        }
        catch (IOException e) {
            this.reportViolation(new Violation(Severity.ERROR, "", e.getMessage(), e));
        }
        catch (URISyntaxException e) {
            this.reportViolation(new Violation(Severity.ERROR, "", e.getMessage(), e));
        }
    }

    private void visitWebInfClasses() {
        File classesDir = new File(this._webappDir, "WEB-INF" + File.separator + "classes");
        if (!classesDir.exists()) {
            return;
        }
        String classesPath = this.getWebappRelativePath(classesDir);
        if (!classesDir.isDirectory()) {
            this.reportViolation(Severity.ERROR, classesPath, "WEB-INF/classes is not a Directory?");
            return;
        }
        for (Rule rule : this._rules) {
            rule.visitWebInfClassesStart(classesPath, classesDir);
        }
        this.visitClassesDir(classesDir, classesDir);
        for (Rule rule : this._rules) {
            rule.visitWebInfClassesEnd(classesPath, classesDir);
        }
    }

    private void visitClassesDir(File classesRoot, File classesDir) {
        File[] files;
        for (File file : files = classesDir.listFiles()) {
            if (file.isFile()) {
                if (file.getName().endsWith(".class")) {
                    this.visitClass(classesRoot, file);
                    continue;
                }
                this.visitClassResource(classesRoot, file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.visitClassesDir(classesRoot, file);
        }
    }

    private void visitClassResource(File classesRoot, File file) {
        String path = this.getWebappRelativePath(file);
        String resourcePath = classesRoot.toURI().relativize(file.toURI()).toASCIIString();
        for (Rule rule : this._rules) {
            rule.visitWebInfClassResource(path, resourcePath, file);
        }
    }

    private void visitClass(File classesRoot, File file) {
        String path = this.getWebappRelativePath(file);
        String className = classesRoot.toURI().relativize(file.toURI()).toASCIIString();
        if ((className = className.replace("/", ".")).endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        for (Rule rule : this._rules) {
            rule.visitWebInfClass(path, className, file);
        }
    }

    private void visitWebInfLib() {
        File[] archives;
        File libDir = new File(this._webappDir, "WEB-INF" + File.separator + "lib");
        if (!libDir.exists()) {
            return;
        }
        String libPath = this.getWebappRelativePath(libDir);
        if (!libDir.isDirectory()) {
            this.reportViolation(Severity.ERROR, libPath, "WEB-INF/lib is not a Directory?");
            return;
        }
        for (Rule rule : this._rules) {
            rule.visitWebInfLibStart(libPath, libDir);
        }
        for (File archive : archives = libDir.listFiles()) {
            if (!archive.isFile()) {
                this.reportViolation(Severity.WARNING, "", "Found non-file in WEB-INF/lib.  Remove it, as it cannot be accessed by the Servlet container or the Webapp: " + archive);
                continue;
            }
            if (archive.getName().toLowerCase().endsWith(".jar")) {
                this.visitWebInfLibJar(libPath, archive);
                continue;
            }
            if (archive.getName().toLowerCase().endsWith(".zip")) {
                this.visitWebInfLibZip(libPath, archive);
                continue;
            }
            this.reportViolation(Severity.WARNING, "", "Found non-archive in WEB-INF/lib.  Remove it, as it cannot be accessed by the Servlet container or the Webapp: " + archive);
        }
        for (Rule rule : this._rules) {
            rule.visitWebInfLibEnd(libPath, libDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitWebInfLibJar(String libPath, File archive) {
        String jarPath = libPath + archive.getName();
        for (Rule rule : this._rules) {
            JarFile jar = null;
            try {
                jar = new JarFile(archive);
                rule.visitWebInfLibJar(jarPath, archive, jar);
            }
            catch (Throwable t) {
                this.reportViolation(new Violation(Severity.ERROR, jarPath, t.getMessage(), t));
            }
            finally {
                if (jar == null) continue;
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitWebInfLibZip(String libPath, File archive) {
        String zipPath = libPath + archive.getName();
        for (Rule rule : this._rules) {
            ZipFile zip = null;
            try {
                zip = new ZipFile(archive);
                rule.visitWebInfLibZip(zipPath, archive, zip);
            }
            catch (Throwable t) {
                this.reportViolation(new Violation(Severity.ERROR, zipPath, t.getMessage(), t));
            }
            finally {
                if (zip == null) continue;
                try {
                    zip.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void visitContents() {
        this.visitDirectoryRecursively(this._webappDir);
    }

    private void visitDirectoryRecursively(File dir) {
        File[] entries;
        String path = this.getWebappRelativePath(dir);
        for (Rule rule : this._rules) {
            rule.visitDirectoryStart(path, dir);
        }
        for (File file : entries = dir.listFiles()) {
            if (!file.isFile()) continue;
            String filepath = path + file.getName();
            for (Rule rule : this._rules) {
                rule.visitFile(filepath, dir, file);
            }
        }
        for (File file : entries) {
            if (!file.isDirectory()) continue;
            this.visitDirectoryRecursively(file);
        }
        for (Rule rule : this._rules) {
            rule.visitDirectoryEnd(path, dir);
        }
    }
}

